#include "XPlaneIO.h"
#include "TimeoutPrompt.h"

void XPlaneIO::diagnostics(Serial & serialInOut) {
    
    TimeoutPrompt top(serialInOut, 2);

    if (top.prompt("\nPress 'd' within 2 seconds for interactive diagnostics", "Dd") == NULL) {
        return;
    }
    
    char c;

    while ((c = top.prompt(30, "\n 1. Analog Input \n 2. \n 3. \n q. Quit \n          Select within 30 seconds", "123Qq")) != NULL
            && c != 'q' && c != 'Q')
    {
        serialInOut.printf("%c was typed \n\n", c);

        switch (c) {
            case '1':
                for (int i = 0; i < _xpAnalogInCount; i++) {
                    pollAnalogIn();
                    serialInOut.printf("Analog Input #%d: ", i + 1);
                    _xpAnalogIn[i]->toString(serialInOut);
                    serialInOut.printf("\n");
                }
                break;
            /*
            case '2':
                break;
            case '3':
                break;
            case 'a':
            case 'A':
                break;
            */
            default:
                serialInOut.printf("%c is not an option \n");
        }
    }
    
    serialInOut.printf("Done \n");
}
