#ifndef XPLANEANALOGIN_H_INCLUDED
#define XPLANEANALOGIN_H_INCLUDED

#include "mbed.h"
#include "Scaler.h"
#include "XPlaneUdpDATA.h"

class XPlaneAnalogIn {
public:

    XPlaneAnalogIn(PinName pin, Scaler<float> scale1, Scaler<float> scale2, int msgIdx, int msgFloatIdx);
    
    /**
     * Perform a read() on the AnalogIn pin, and return that value.
     */
    float read_unscaled();

    /**
     * Perform a read() on the AnalogIn pin, and return the value scaled by the scale1 and scale2 ranges.
     * The range used for the scaling is returned via the reference parameter:
     *     0 = input fell in between the ranges (i.e. deadband zone), so scaled output is midpoint between scale1 outputTo and scale2 outputFrom 
     *     1 = input fell in the scale1 range
     *     2 = input fell in the scale2 range
     *     3 = input was less than scale1 inputFrom, so scaled output is (bounded by) scale1 outputFrom
     *     4 = input was greater than scale2 inputTo, so scaled output is (bounded by) scale2 outputTo
     * The scaledOutputNoChange reference parameter will be set true if the scaled value didn't changed since the last read.
     */
    float read_scaled(int & range, bool & scaledOutputNoChange);
    
    
    // Property accessors and mutators
    
    //Scaler<float> scale1();
    //void scale1(Scaler<float> scale1);
    
    //Scaler<float> scale2();
    //void scale2(Scaler<float> scale2);
    
    int xplaneDATAMsgIdx();
    //void xplaneDATAMsgIdx(int xplaneDATAMsgIdx);
    
    int xplaneDATAMsgFloatIdx();
    //void xplaneDATAMsgFloatIdx(int xplaneDATAMsgFloatIdx);
    
    /**
     * Print a representation of this instance to outputStream.
     */
    void toString(FILE * outputStream);

private:

    PinName _pin;
    Scaler<float> _scale1;
    Scaler<float> _scale2;
    int _xplaneDATAMsgIdx;
    int _xplaneDATAMsgFloatIdx;
    
    AnalogIn _ain;
    
    float _lastUnscaledRead;
    float _lastScaledRead;
    int _lastScaleRange;
};

#endif // XPLANEANALOGIN_H_INCLUDED
