#ifndef TIMEOUTPROMPT_H_INCLUDED
#define TIMEOUTPROMPT_H_INCLUDED

#include "mbed.h"

class TimeoutPrompt {
public:

    TimeoutPrompt(Serial & serialInOut, int defaultTimeoutSeconds);
    
    /**
     * Output the given prompt for timeoutSeconds. If a character is input that matches
     * one of the validChars, then return it. Otherwise, if no valid character is
     * pressed within the timeout, then return NULL.
     */
    char prompt(int timeoutSeconds, char *promptString, char* validChars);

    /**
     * Overloaded method that uses defaultTimeoutSeconds.
     */
    char prompt(char *promptString, char* validChars);
    
private:

    Serial & _serialInOut;
    int _defaultTimeoutSeconds;
    Timer _timer;
};

#endif // TIMEOUTPROMPT_H_INCLUDED
