/**
 *****************************************************************************
 * File Name    : UniStepperMotor.h
 *
 * Title        : Unipolar Stepper Motor Class Header File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2012/07/8    Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2012 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

#ifndef MBED_STEPPER_MOTOR_H
#define MBED_STEPPER_MOTOR_H
 
/* Includes ----------------------------------------------------------------- */
#include "mbed.h"
                                                                                                                                    
/* typedef ------------------------------------------------------------------ */
typedef enum {PWM_ON, PWM_OFF} pwm_state;
typedef enum {CLOCK_WISE, ANTI_CLOCK_WISE} motor_dir;

struct speed_data_t {
    int max_pulse_count;
    int pwm_ratio;
    uint8_t *clockwise_ptn;
    uint8_t *anticlockwise_ptn;
    int ptn_count;
};

/* define ------------------------------------------------------------------- */
#define PULSE_INTERVAL  14        // 14us
#define MAXSPEED        255

/* macro -------------------------------------------------------------------- */
/* variables ---------------------------------------------------------------- */
/* class -------------------------------------------------------------------- */

class StepperMotor {
public:
    StepperMotor(PinName x_pin_no, PinName y_pin_no, PinName nx_pin_no, PinName ny_pin_no, motor_dir set_direction);
    ~StepperMotor();

    void SetSpeed(int speed);
    void PulseEnable(void);
    void PulseDisable(void);

private:
    pwm_state   state;
    motor_dir   direction;
    motor_dir   forward_direction;
    motor_dir   backward_direction;

    int         ptn_index;
    int         ptn_count;
    int         pwm_ratio;
    int         pwm_on_count;
    int         pwm_off_count;
    int         max_pulse_count;
    int         pulse_count;
    uint8_t     *ptn;
    uint8_t     ptn_data;

    DigitalOut _x;
    DigitalOut _y;
    DigitalOut _nx;
    DigitalOut _ny;

    Ticker Pulse;

    void SetPulse14us(void);
    void PulseOut(void);
    void PulseStop(void);
};

#endif