#include "mbed.h"
#include "StepperMotor.h"

BusOut myleds(LED1, LED2, LED3, LED4);

Serial pc(USBTX, USBRX);

DigitalOut ae_fxma108(p29);

DigitalIn pb(p19);
DigitalIn pw(p20);

const char Welcome_Message[] =
    "\r\nHello mbed World!\r\n"
    "Expand your creativity and enjoy making.\r\n\r\n"
    "Stepper Motor Test Mode.\r\n\r\n";


StepperMotor r_motor(p28,p27,p26,p25);
StepperMotor l_motor(p24,p23,p22,p21);

int main() {
    pc.printf(Welcome_Message);

    int old_pb=0;
    int new_pb;
    int old_pw=0;
    int new_pw;
    static int speed = 0;

    pb.mode(PullUp);
    pw.mode(PullUp);

    ae_fxma108 = 0;

    r_motor.SetSpeed(speed,CLOCK_WISE);
    l_motor.SetSpeed(speed,ANTI_CLOCK_WISE);
 
     r_motor.PulseEnable();
    l_motor.PulseEnable();

    while(1) {
        new_pb = pb;
        if ((new_pb==0) && (old_pb==1)) {
            if (speed == 0) continue;
            speed--;
            pc.printf("speed: %d\r\n",speed);
            r_motor.SetSpeed(speed,CLOCK_WISE);
            l_motor.SetSpeed(speed,ANTI_CLOCK_WISE);
        }
        old_pb = new_pb;
    
    
        new_pw = pw;
        if ((new_pw==0) && (old_pw==1)) {
            if (speed == 10) continue;
            speed++;
            
            pc.printf("speed: %d\r\n",speed);
            r_motor.SetSpeed(speed,CLOCK_WISE);
            l_motor.SetSpeed(speed,ANTI_CLOCK_WISE);
        }
        old_pw = new_pw;

        myleds = speed;
    }
}
