#include "mbed.h"
#include "MyLCD.h"

I2C i2c(dp5,dp27);        // sda, scl <== LPC1114FN28
MyLCD lcd(&i2c);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

char osamru_bitmap[6][8] =
{
    {   4,  3, 15,  7, 15, 18, 18, 14},             // おさる　その１
    {  31, 31, 31, 31,  3,  0, 12, 18},             // おさる　その２
    {   0, 24, 28, 30, 18,  2, 12, 18},             // おさる　その３
    {  30, 15, 30, 12,  6,  2,  1,  0},             // おさる　その４
    {  22, 12,  0, 17, 24, 30,  1, 30},             // おさる　その５
    {  22, 12,  4, 18,  2,  4, 24,  0}              // おさる　その６
};

int main() {

    // LCD の外字を登録
    for (int i=0; i < 6;i++)
    {
        lcd.saveCustomCharacter(i, osamru_bitmap[i]);//
        lcd.mapCustomCharacter(i,i);
    }
    
    lcd.clear();
    lcd.hideCursor();
     
    lcd.gotoCursor(0, 0);
    lcd.printChar(0);            // おさる　その１
    lcd.printChar(1);            // おさる　その２
    lcd.printChar(2);            // おさる　その３
    lcd.printStr(">Monkee LCD<");

    lcd.gotoCursor(0, 1);
    lcd.printChar(3);            // おさる　その４
    lcd.printChar(4);            // おさる　その５
    lcd.printChar(5);            // おさる　その６
    lcd.printStr("[\265\273\331\300\336 \263\257\267\267!]"); // 8進表記すればカタカナも表示可

    led1 = 1;
    led2 = 0;
    while(1) {
        wait(1);
        led1 = !led1;
        led2 = !led2;
    }
}
