/**
 *****************************************************************************
 * File Name    : MyLCD.cpp
 *
 * Title        : ORGINAL I2C LCD Display Claass Source File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768, mbed LPC1114FN28  etc
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2013/12/11   Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2013 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

/* Includes ----------------------------------------------------------------- */
#include "mbed.h"
#include "MyLCD.h"
#include <string.h>

/* Private typedef ---------------------------------------------------------- */
/* Private define ----------------------------------------------------------- */
/* Private macro ------------------------------------------------------------ */
/* Private variables -------------------------------------------------------- */

/* member fanctions --------------------------------------------------------- */


// Constractor
MyLCD::MyLCD(I2C *i2c): _i2c(i2c)
{
    _column = 0;
    _row = 0;
}

int MyLCD::writeBytes(const char *data, int length, bool repeated)
{
    wait_us(i2c_bit_wait_us);
    _i2c->start();

    wait_us(i2c_bit_wait_us);
    if (_i2c->write(i2c_addr) != 1)
    {
        wait_us(i2c_bit_wait_us);
        _i2c->stop();
        return _i2cFAILURE;
    }

    for (int i = 0; i < length; i++)
    {
        wait_us(i2c_bit_wait_us);
        if (_i2c->write(data[i]) != 1)
        {
            wait_us(i2c_bit_wait_us);
            _i2c->stop();
            return _i2cFAILURE;
        }
    }
    if (!repeated)
    {
        wait_us(i2c_bit_wait_us);
        _i2c->stop();
    }
    return _i2cSUCCESS;
}

int MyLCD::gotoCursor( int x, int y )
{
    char buff[4] = { ESC, 'L', x, y };

    _column = x;
    _row = y;

    return writeBytes(buff, sizeof(buff));
}


int MyLCD::home(void)
{
    char buff[2] = { ESC, 'H' };

    _column = 0;
    _row = 0;

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::clear(void)
{
    char buff[2] = { ESC, 'C' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::saveCustomCharacter(int romCharNum, char lcdCharData[])
{
    int ret;

    char buff[3] = { ESC, 'S', romCharNum };

    ret = writeBytes(buff, sizeof(buff), true);

    if (ret == _i2cSUCCESS)
    {
        ret = writeBytes(lcdCharData, 8, false);
    }
    wait_ms(100);

    return ret;
}

int MyLCD::mapCustomCharacter(int romCharNum, int lcdCharNum)
{
    char buff[4] = { ESC, 'M', romCharNum, lcdCharNum };

    return writeBytes(buff, sizeof(buff));
}


int MyLCD::offDisplay(void)
{
    char buff[2] = { ESC, 'X' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::onDisplay(void)
{
    char buff[2] = { ESC, 'N' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::blinkCharacter(void)
{
    char buff[2] = { ESC, 'B' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::dispCursor(void)
{
    char buff[2] = { ESC, 'D' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::blinkCursor(void)
{
    char buff[2] = { ESC, 'E' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::hideCursor(void)
{
    char buff[2] = { ESC, 'H' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::moveLeftCursor(void)
{
    char buff[2] = { ESC, '-' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::moveRightCursor(void)
{
    char buff[2] = { ESC, '+' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::moveLeftDisplay(void)
{
    char buff[2] = { ESC, '<' };

    return writeBytes(buff, sizeof(buff));
}

int MyLCD::moveRightDisplay(void)
{
    char buff[2] = { ESC, '>' };

    return writeBytes(buff, sizeof(buff));
}

// 一文字表示
int MyLCD::printChar(char chr)
{
    return writeBytes(&chr, 1);
}

int MyLCD::printStr(const char *s)
{
    return writeBytes(s, strlen(s));
}


int MyLCD::_putc(int value)
{
    if (value == '\n')
    {
        _column = 0;
        _row++;
        if (_row >= rows())
        {
            _row = 0;
        }
    }
    else
    {
        character(_column, _row, value);
        _column++;
        if (_column >= columns())
        {
            _column = 0;
            _row++;
            if (_row >= rows())
            {
                _row = 0;
            }
        }
    }
    return value;
}

int MyLCD::_getc()
{
    return -1;
}

void MyLCD::character(int column, int row, int c)
{
    gotoCursor(_column, row );
    printChar(c);
}

int MyLCD::columns()
{
    return display_columns;
}

int MyLCD::rows()
{
    return display_rows;
}
