/**
 *****************************************************************************
 * File Name    : MyLCD.h
 *
 * Title        : ORGINAL I2C LCD Display Claass Header File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768, mbed LPC1114FN28  etc
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2013/12/06   Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2013 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

#ifndef __MYLCD_H_
#define __MYLCD_H_

/* Includes ----------------------------------------------------------------- */
#include "mbed.h"
/* typedef ------------------------------------------------------------------ */

/* define ------------------------------------------------------------------- */
#define ESC             0x1B
#define I2C_ADDR_MYLCD  0x32
#define _i2cSUCCESS     0
#define _i2cFAILURE     1

/* macro -------------------------------------------------------------------- */
/* variables ---------------------------------------------------------------- */
/* class -------------------------------------------------------------------- */
class MyLCD : public Stream
{
private:
    static const int i2c_addr = I2C_ADDR_MYLCD << 1;
    static const int i2c_bit_wait_us = 20;
    static const int i2c_command_wait_ms = 4;
    static const int display_columns = 16;
    static const int display_rows = 2;

    I2C *_i2c;
    int _column, _row;
    int writeBytes(const char *data, int length, bool repeated=false);

protected:
    virtual int _putc(int value);
    virtual int _getc();
    
    void character(int column, int row, int c);
    int columns();
    int rows();

public:
    MyLCD(I2C *i2c);
#if DOXYGEN_ONLY
    int putc(int value);
    int printf(const char* format, ...);
#endif
    
    int gotoCursor( int x, int y );
    int home(void);
    int clear(void);
    int offDisplay(void);
    int onDisplay(void);
    int blinkCharacter(void);
    int dispCursor(void);
    int blinkCursor(void);
    int hideCursor(void);
    int moveLeftCursor(void);
    int moveRightCursor(void);
    int moveLeftDisplay(void);
    int moveRightDisplay(void);
    int printChar(char chr);
    int printStr(const char *s);
    
    int saveCustomCharacter(int romCharNum, char lcdCharData[]);
    int mapCustomCharacter(int romCharNum, int lcdCharNum);
};

#endif /* __MYLCD_H_ */
