#include "mbed.h"
#include "My7SEG.h"

I2C i2c(dp5,dp27);        // sda, scl
My7SEG _7seg(&i2c);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

int main()
{
    int hour,min,sec;
    char buf[9];

    hour = 0;
    min = 0;
    sec = 0;
    led1 = 1;
    led2 = 0;
    while(1) {
        sprintf(buf,"%02d.%02d.%02d",hour,min,sec);
        _7seg.clear();
        _7seg.printStr(buf);
        led1 = !led1;
        led2 = !led2;
        
        sec++;
        if (sec > 59) {
            sec = 0;
            min++;
        }

        if (min > 59) {
            min = 0;
            hour++;
        }

        if (hour > 23) {
            hour = 0;
        }

        wait(1);
    }
}
