/**
 *****************************************************************************
 * File Name    : My7SEG.h
 *
 * Title        : ORGINAL I2C LCD Display Claass Header File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768, mbed LPC1114FN28  etc
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2013/12/06   Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2013 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

#ifndef __My7SEG_H_
#define __My7SEG_H_

/* Includes ----------------------------------------------------------------- */
#include "mbed.h"
/* typedef ------------------------------------------------------------------ */

/* define ------------------------------------------------------------------- */
#define ESC             0x1B
#define I2C_ADDR_MY7SEG  0x33
#define _i2cSUCCESS     0
#define _i2cFAILURE     1

/* macro -------------------------------------------------------------------- */
/* variables ---------------------------------------------------------------- */
/* class -------------------------------------------------------------------- */
class My7SEG
{
private:
    static const int i2c_addr = I2C_ADDR_MY7SEG << 1;
    static const int i2c_bit_wait_us = 20;
    static const int i2c_command_wait_ms = 4;

    I2C *_i2c;
    int writeBytes(const char *data, int length, bool repeated=false);

protected:


public:
    My7SEG(I2C *i2c);

    int clear(void);
    int shift_left(void);
    int shift_right(void);
    int rotato_left(void);
    int rotato_right(void);
    int printChar(char c);
    int printPosChar(int pos, char chr);
    int printStr(const char *s);

};

#endif /* __My7SEG_H_ */
