/**
 *****************************************************************************
 * File Name    : My7SEG.cpp
 *
 * Title        : ORGINAL I2C LCD Display Claass Source File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768, mbed LPC1114FN28  etc
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2013/12/11   Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2013 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

/* Includes ----------------------------------------------------------------- */
#include "mbed.h"
#include "My7SEG.h"

/* Private typedef ---------------------------------------------------------- */
/* Private define ----------------------------------------------------------- */
/* Private macro ------------------------------------------------------------ */
/* Private variables -------------------------------------------------------- */
/* member fanctions --------------------------------------------------------- */

// Constractor
My7SEG::My7SEG(I2C *i2c): _i2c(i2c)
{
}

int My7SEG::writeBytes(const char *data, int length, bool repeated)
{
    wait_us(i2c_bit_wait_us);
    _i2c->start();

    wait_us(i2c_bit_wait_us);
    if (_i2c->write(i2c_addr) != 1)
    {
        wait_us(i2c_bit_wait_us);
        _i2c->stop();
        return _i2cFAILURE;
    }

    for (int i = 0; i < length; i++)
    {
        wait_us(i2c_bit_wait_us);
        if (_i2c->write(data[i]) != 1)
        {
            wait_us(i2c_bit_wait_us);
            _i2c->stop();
            return _i2cFAILURE;
        }
    }
    if (!repeated)
    {
        wait_us(i2c_bit_wait_us);
        _i2c->stop();
    }
    return _i2cSUCCESS;
}

int My7SEG::clear(void)
{
    char buff[2] = { ESC, 'C' };

    return writeBytes(buff, sizeof(buff));
}

int My7SEG::shift_left(void)
{
    char buff[2] = { ESC, '<' };

    return writeBytes(buff, sizeof(buff));
}

int My7SEG::shift_right(void)
{
    char buff[2] = { ESC, '>' };

    return writeBytes(buff, sizeof(buff));
}

int My7SEG::rotato_left(void)
{
    char buff[2] = { ESC, '[' };

    return writeBytes(buff, sizeof(buff));
}

int My7SEG::rotato_right(void)
{
    char buff[2] = { ESC, ']' };

    return writeBytes(buff, sizeof(buff));
}

// 一文字表示
int My7SEG::printChar(char c)
{
    return writeBytes(&c, 1);
}

int My7SEG::printPosChar(int pos, char chr)
{
    char buff[4];
    
    if( pos < 0 && 7 < pos )
    {
        return _i2cFAILURE;
    }
    
    buff[0] = ESC;
    buff[1] = 'L';
    buff[2] = '0' + pos;
    buff[3] = chr;

    return writeBytes(buff, sizeof(buff));
}

int My7SEG::printStr(const char *s)
{
    int ret;
    char c;

    ret = _i2cSUCCESS;
    while ((c = *s++)!=NULL)
    {
        ret = writeBytes(&c, 1);
        if (ret == _i2cFAILURE)
        {
            return ret;
        }
    }

    return ret;
}

///////////////////////////////////////////////
