#include "mbed.h"
#include "SDFileSystem.h"

/*
LPC1114FN28 with SD Card Test
digital connector pins and the SPI connector pins as follows:
Signal  PIN
MOSI    dp2
MISO    dp1
SCK     dp6
/CS     dp4
*/

SDFileSystem sd(dp2, dp1, dp6, dp4, "sd"); // the pinout on the mbed Cool Components workshop board
Serial uart(dp16, dp15); // UART .. P1_7: TX (pin 16), P1_6: RX (pin 15)

int main()
{
    uart.baud(115200);  // Baud rate
    uart.printf("Hello World!\r\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        uart.printf("Could not open file for write\r\n");
        exit(1);
    }
    for (int i=0; i<100; i++) {
        fprintf(fp, "Hello fun SD Card World! :: NO %d\r\n",i);
    }
    fclose(fp);

    uart.printf("Goodbye World!\r\n");
    
    return 0;
}
