#include "mbed.h"
#include "_24LCXXX.h"

I2C i2c(dp5,dp27);        // sda, scl
Serial pc(dp16, dp15); // tx, rx
_24LCXXX eeprom(&i2c, 0x50);

DigitalOut myled(LED1);

int main() {
    pc.baud(9600);
    char data1;
    int data2;
    
    pc.printf("memoroy byte data write!\n");
    eeprom.byte_write(0, 1);
    eeprom.byte_write(1, 2);
    eeprom.byte_write(2, 3);
    eeprom.byte_write(3, 4);
    pc.printf("end\n");
    
    eeprom.nbyte_read( 0, &data1, 1 );
    pc.printf("0:%02x ",data1);
    eeprom.nbyte_read( 1, &data1, 1 );
    pc.printf("1:%02x ",data1);
    eeprom.nbyte_read( 2, &data1, 1 );
    pc.printf("2:%02x ",data1);
    eeprom.nbyte_read( 3, &data1, 1 );
    pc.printf("3:%02x ",data1);
    pc.printf("\nend\n");   
    
    pc.printf("memoroy int data write!\n");
    data2 = 100;
    eeprom.nbyte_write( 10, &data2, sizeof(int));
    pc.printf("\nend\n");

    eeprom.nbyte_read( 10, &data2, sizeof(int) );
    pc.printf("int:%d ",data2);
    pc.printf("\nend\n");

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
