/**
 *****************************************************************************
 * File Name    : GyroSensor.h
 *
 * Title        : Gyro Sensor Class Header File
 * Revision     : 0.1
 * Notes        :
 * Target Board : mbed NXP LPC1768
 * Tool Chain   : ????
 *
 * Revision History:
 * When         Who         Description of change
 * -----------  ----------- -----------------------
 * 2012/07/10    Hiroshi M   init
 *****************************************************************************
 *
 * Copyright (C) 2012 Hiroshi M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **/

#ifndef MBED_GYRO_SENSOR_H
#define MBED_GYRO_SENSOR_H

/* Includes ----------------------------------------------------------------- */
#include "mbed.h"

/* typedef ------------------------------------------------------------------ */
typedef enum {CLEAR,INI,IDLE,READY} GyroState;

typedef GyroState (*GYRO_CALLBACK_FUNC)(int gyv, int gyv, int offset);
typedef int (*GET_DISTANCE_GAIN_FUNC)(void);
typedef int (*GET_DISTANCE_FEEDBACK_FUNC)(void);

/* define ------------------------------------------------------------------- */
#define INI_COUNT 16
#define AV_COUNT 32

/* macro -------------------------------------------------------------------- */
/* variables ---------------------------------------------------------------- */

/* class define --------------------------------------------------------------*/
class GyroSensor
{
public:
    GyroSensor(PinName _pin_no, GYRO_CALLBACK_FUNC _p_callack, GET_DISTANCE_FEEDBACK_FUNC _p_feedback, GET_DISTANCE_GAIN_FUNC _p_disatnce_gain);
    ~GyroSensor();
    
    void Enable(void);
    void Disable(void);
    
    GyroState getState(void);
    int getAngle(void);
    int getVelocity(void);
    int getOffset(void);
    
    void setReady(void);
    void setIdle(void);
    

private:
    int gya;            //
    int gyv;            //
    int offset;         //

    int adcav;
    int offset_count;
    int offset_ini_count;
    long int offset_sum;
    long int offset_sum_old;
    long int offset_sum_ini;
    long int offset_sum_old_ini;
    long int gyaa;
    
    int d_fb;
    int d_gain;

    GyroState state;
    
    GYRO_CALLBACK_FUNC          callback;
    GET_DISTANCE_FEEDBACK_FUNC  getDistanceFeedback;
    GET_DISTANCE_GAIN_FUNC      getDisatnceGain;
   
    void getParameter(void); 
    
    AnalogIn    gyro_adc_in;
    Ticker      Pulse;
    
    void ad_conv(void);
    void gyro_control(void);

};

#endif