#include "mbed.h"
#include "DHT.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

#define ECHO_SERVER_PORT   7

#include "mbed.h"
 
int arrivedcount = 0;
 
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main (void)
{
    DHT sensor(D4, DHT11);
    AnalogIn ain(A1);
    baud(115200);
    printf("Wait a second...\r\n");
    MQTTEthernet ipstack = MQTTEthernet();
    
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "222.98.173.244";
    int port = 1883;
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\n", rc);
        
    char MQTTClientID[30];
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    sprintf(MQTTClientID,"WIZwiki-W7500-client-%d",rand()%1000);
    data.clientID.cstring = MQTTClientID;
    data.username.cstring = "testuser";
    data.password.cstring = "testpassword";  

    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\n", rc);
        
    MQTT::Message message;
    char buf[100];
    int error = 0;
    float hum = 0.0f, temp = 0.0f;
    char i = 0;
    while (true)
    {
        if(i > 100) i = 0;
        error = sensor.readData();
        if (0 == error) {
            hum = sensor.ReadHumidity();
            temp = sensor.ReadTemperature(CELCIUS);
        }
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        
        sprintf(buf, "%3.1f", hum);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("Wiznet/humidity", message);
        
        sprintf(buf, "%3.1f", temp);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("Wiznet/temperature", message);
        
        sprintf(buf, "%3.1f", (rand()%1000)/10.0);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("Wiznet/fluidgauge/A", message);
        
        sprintf(buf, "%3.1f", (rand()%1000)/10.0);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("Wiznet/fluidgauge/B", message);
        
        sprintf(buf, "%3.1f", (rand()%1000)/10.0);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("Wiznet/fluidgauge/C", message);
        client.yield(1000);
        //wait(100);
    }
}

