#include "mbed.h"
#include "DHT.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

#define ECHO_SERVER_PORT   7

#include "mbed.h"
 
int arrivedcount = 0;

DigitalOut sw1(PC_08);
DigitalOut sw2(PC_09);
DigitalOut sw3(PC_05);
 

void sw1_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw1 = 1;
    } else{
        sw1 = 0;
    }
}

void sw2_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw2 = 1;
    } else{
        sw2 = 0;
    }
}

void sw3_messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    if( strncmp((char*)message.payload,"1",message.payloadlen) == 0 ){
        sw3 = 1;
    } else{
        sw3 = 0;
    }
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main (void)
{   
    sw1 = 0; sw2 = 0; sw3 = 0;
    baud(115200);
    printf("Wait a second...\r\n");
    
    MQTTEthernet ipstack = MQTTEthernet();
    printf("IP Address : %s\r\n",ipstack.getEth().getIPAddress());
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "222.98.173.239";
    printf("connect to %s\r\n",hostname);
    int port = 1883;
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
    {
        printf("rc from TCP connect is %d\n", rc);
        return 0;
    }
    printf("TCP connection is successful\r\n");
        
    char MQTTClientID[30];
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    sprintf(MQTTClientID,"WIZwiki-W7500-client-%d",rand()%10000);
    data.clientID.cstring = MQTTClientID;
    data.username.cstring = "wiznetacademy";
    data.password.cstring = "wiznet1324";  
    
    if ((rc = client.connect(data)) != 0)
    {
        printf("rc from MQTT connect is %d\r\n", rc);
        return 0;
    }
    printf("MQTT connection is successful\r\n");

        
    char *sw1 = "light/control";
    if ((rc = client.subscribe(sw1, MQTT::QOS0, sw1_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw1\r\n");
    
    char *sw2 = "boiler/control";
    if ((rc = client.subscribe(sw2, MQTT::QOS0, sw2_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw2\r\n");
        
    char *sw3 = "radio/control";
    if ((rc = client.subscribe(sw3, MQTT::QOS0, sw3_messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\r\n", rc);
        return 0;
    }
    printf("Added subscription for sw3\r\n");

    while (true)
    {
        client.yield(5000);
    }
}

