#include "mbed.h"
#include "DNSClient.h"
#include "EthernetInterface.h"

int main() {
    
    EthernetInterface eth;
    
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xFF, 0xFF, 0xFF};
    eth.init(mac_addr, "222.98.173.239", "255.255.255.192", "222.98.173.254"); // USE Static IP
    //eth.init(mac_addr); //Use DHCP
    eth.connect();
     
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    DNSClient client;
    
    client.lookup("openweathermap.org");
    printf("http://openweathermap.org/ ip address: %d.%d.%d.%d\r\n",(client.ip&0xff000000)>>24,(client.ip&0x00ff0000)>>16,(client.ip&0x0000ff00)>>8,(client.ip&0x000000ff)>>0);
    eth.disconnect();
    
    printf("Disconnected!"); 
}