#include "mbed.h"
#include "EthernetInterface.h"

int main() {
    
    EthernetInterface eth;
    
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};
    eth.init(mac_addr, "192.168.0.180", "255.255.255.0", "192.168.0.1"); // USE Static IP
    //eth.init(mac_addr); //Use DHCP
    eth.connect();
     
    printf("IP Address is %s\r\n", eth.getIPAddress());

    TCPSocketConnection tcp_sock;
    tcp_sock.connect("192.168.0.244", 4545);
    char message[] = "Hello World!\r\n";
    tcp_sock.send(message, sizeof(message)-1);
    char buffer[400];
    int ret;
    while (true)
    {
        ret = tcp_sock.receive(buffer, sizeof(buffer)-1);
        if (ret > 0)
        {
            buffer[ret] = '\0';
            printf("Received %d chars from server: %s\n", ret, buffer);
        }
    }
    
    tcp_sock.close();
    
    eth.disconnect();
    
    printf("Disconnected!"); 
}