#include "mbed.h"
#include "EthernetInterface.h"

int main() {
    
    EthernetInterface eth;
    
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xFF, 0xFF, 0xFF};
    char message[] = "Hello World!\r\n";
    char buffer[400];
    int ret;
    
    eth.init(mac_addr, "192.168.0.180", "255.255.255.0", "192.168.0.1"); // USE Static IP
    //eth.init(mac_addr); //Use DHCP
    eth.connect();
     
    printf("IP Address is %s\r\n", eth.getIPAddress());

    TCPSocketServer server;
    server.bind(4545);
    server.listen();
    
    while (true)
    {
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 10000);//10 sec
        
        printf("Connection from: %s\r\n", client.get_address());
        while(true){
            int n = client.receive(buffer, sizeof(buffer));
            if(n <= 0) break;
            buffer[n] = '\0';
            client.send(buffer,n);
            if(n <= 0) break;
        }
        printf("Disconnected\r\n");
        client.close();
    }
    server.close();
    
    eth.disconnect();
    
    printf("Disconnected!"); 
}