/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*include library*/
//mbed library
#include "mbed.h"

//HW W5500 library
#include "WIZnetInterface.h"

//HW Touch lcd library
#include "SeeedStudioTFTv2.h"

//SW Font library
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

//SW HTTPClient library
#include "HTTPClient.h"
//
#include "SDFileSystem.h"
//SDFileSystem sd(D11,D12,D13,D4, "sdc");

/*Port define and initialize*/

//Define W5500 port and initialization
SPI spi(D11,D12,D13);
WIZnetInterface ethernet(&spi,D10,D15);

#include "MySeeedStudioTFTv2.h"

//Define TFT LCD port and initialization
#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4
MySeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);


#include "typedefinition.h"
//UART to USB initialization for debug message
Serial pc(USBTX, USBRX);

Serial sound(PA_11,PA_12);

//Ethernet information pre definition
const char * IP_Addr    = "222.98.173.249";
const char * IP_Subnet  = "255.255.255.192";
const char * IP_Gateway = "222.98.173.254";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

void SndPlay(int TrackNumber);
void Sndvol(unsigned char updn);
void basicDisplay(void);
void weatherDisplay(void);

int main()
{
    //Set baudrate of "U2U"
    pc.baud(115200);
    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls();
  
    //Application Start message
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    TFT.printf(" Application Start.\n");
    //Ethernet configuration
    mbed_mac_address((char *)MAC_Addr);
    int ret = ethernet.init(MAC_Addr);
    if (!ret) {
        TFT.printf(" Ethernet Initialized\n MAC: %s\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            TFT.printf(" IP: %s\r\n MASK: %s\r\n GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            TFT.printf(" Error ethernet.connect() - ret = %d\r\n", ret);
            exit(0);
        }
    } else {
        TFT.printf(" Error ethernet.init() - ret = %d\r\n", ret);
        exit(0);
    }
    TFT.cls();
    basicDisplay();
    wait(20);
    weatherDisplay();
    while(1)
    {
    }
    //point p;
//    d
//    while(1)
//    {
//      TFT.getPixel(p);
//      TFT.locate(0,100);
//      TFT.printf("X: %6d, Y: %6d",p.x,p.y);
//    }
      //  TFT.printf("msg : %s\r\n",get_msg);
//        if(!ret)
//        {
//          TFT.printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
//          TFT.printf("Result: %s\r\n", str);
//        }
//        else
//        {
//          TFT.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
//        }
//        wait(20);
//    }
        
}

void SndPlay(int TrackNumber)
{
    char tempBuffer[50];
    sprintf(tempBuffer,"play,%04d,$",TrackNumber);
    sound.printf("%s",tempBuffer);
    pc.printf("%s",tempBuffer);
}

void SndVol(unsigned char updn)
{
    if(updn)
        sound.printf("vol+$");
    else
        sound.printf("vol-$");
}

void basicDisplay(void)
{
    TFT.locate(0,80);
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.printf(" 15.08.09\n");
    TFT.printf("   21:08\n\n");
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.printf(" 29'C  57/100");
}

void weatherDisplay(void)
{
    TFT.background(White);
    TFT.foreground(Black);
    TFT.cls();
    int ret=0;
    char str[8192];
    char get_msg[256]= "";
    char *CurrentAddr=0;
    kmaWid kwid[5];
 
    HTTPClient http;   
    sprintf(get_msg,"http://www.kma.go.kr/wid/queryDFS.jsp?gridx=60&gridy=127");
    ret = http.get(get_msg, str, sizeof(str),0);
    char tempBufferForParser[50];
    
    for(int i = 0 ; i < 5 ; i++)
    {
        sprintf(tempBufferForParser,"<data seq=\"%d\">",i);
        CurrentAddr = strstr(str,tempBufferForParser);
        CurrentAddr = strstr(CurrentAddr,"<hour>");
        if((*(CurrentAddr+7)) == '<'){
            kwid[i].hour[0] = *(CurrentAddr+6);
            kwid[i].hour[1] = 0;
            kwid[i].hour[2] = 0;
            }
        else{
            kwid[i].hour[0] = *(CurrentAddr+6);
            kwid[i].hour[1] = *(CurrentAddr+7);
            kwid[i].hour[2] = 0;
            }
        pc.printf("hour:%s \r\n",kwid[i].hour);
        CurrentAddr = strstr(CurrentAddr,"<temp>");
        memcpy(kwid[i].temperature,(CurrentAddr+6),4);
        kwid[i].temperature[4]=0;
        pc.printf("temp:%s \r\n",kwid[i].temperature);
        CurrentAddr = strstr(CurrentAddr,"<sky>");
        kwid[i].sky = *(CurrentAddr+5);
        pc.printf("sky:%c \r\n",kwid[i].sky);
    }
    char tempBuffer[50];
    sprintf(tempBuffer,"/sdc/%c.bmp",kwid[0].sky);
    FILE *fp;
    fp = fopen(tempBuffer,"r");
    TFT.cls();
    TFT.DrawBitmapFile(20,40,fp);
    fclose(fp);
    TFT.locate(0,0);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.printf("Seoul");
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(0,240);
    TFT.printf("  %s'C",kwid[0].temperature);
    switch(kwid[0].sky)
    {
        case '1':
            SndPlay(1);
            break;
        case '2':
        case '3':
        case '4':
            SndPlay(2);
            break;
        case '5':
            SndPlay(3);
            break;
        case '6':
        case '7':
            SndPlay(4);
            break;
        default:
            break;
    }
}   