/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*include library*/
//mbed library
#include "mbed.h"

//HW W5500 library
#include "WIZnetInterface.h"

//HW Touch lcd library
#include "SeeedStudioTFTv2.h"

//HW&SW SDFilsystem library
#include "SDFileSystem.h"
SDFileSystem sd(D11,D12,D13,D4, "sd");

//SW Font library
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

//SW HTTPClient library
#include "HTTPClient.h"

/*Port define and initialize*/

//Define W5500 port and initialization
SPI spi(D11,D12,D13);
WIZnetInterface ethernet(&spi,D10,D0);


//Define TFT LCD port and initialization
#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4
SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);

//UART to USB initialization for debug message
Serial pc(USBTX, USBRX);

//Ethernet information pre definition
const char * IP_Addr    = "222.98.173.249";
const char * IP_Subnet  = "255.255.255.192";
const char * IP_Gateway = "222.98.173.254";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

int main()
{
    //Set baudrate of "U2U"
    pc.baud(115200);

    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls();
  
    //Application Start message
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    TFT.printf(" Application Start.\n");
    //Ethernet configuration
    mbed_mac_address((char *)MAC_Addr);
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    if (!ret) {
        TFT.printf(" Ethernet Initialized\n MAC: %s\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            TFT.printf(" IP: %s\r\n MASK: %s\r\n GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            TFT.printf(" Error ethernet.connect() - ret = %d\r\n", ret);
            exit(0);
        }
    } else {
        TFT.printf(" Error ethernet.init() - ret = %d\r\n", ret);
        exit(0);
    }
    wait(0.5);

    //HTTPClient http;
//    
//    char str[8192];
//    char get_msg[256]= "";
//
//    sprintf(get_msg,"http://www.kma.go.kr/wid/queryDFS.jsp?gridx=59&gridy=127");
//    
//    ret = http.get(get_msg, str, sizeof(str),0);
//    
//    if(ret == HTTP_OK)
//    {
//        TFT.printf(" HTTP_OK\r\n");
//    }
//    else
//    {
//        TFT.printf("error code: %d\r\n",ret);
//    }
//    char *startAddr;
//    startAddr = strstr(str,"<tm>");
//    if(startAddr == 0)
//    {
//        TFT.printf("There is no data.\r\n");
//    }
//    else
//    {
//        strncpy(get_msg,startAddr+4,12);
//        *(get_msg+12) = 0;
//        TFT.printf("%s",get_msg);
//    }
    TFT.cls();
    FILE *fp;
    fp = fopen("/sd/Weather_Icons_02.bmp","r");
    fseek(fp, 0, SEEK_SET);
    TFT.BMP_16(100,100,fp);
    printf("1234567890");
    while(1)
    {
    }
    //point p;
//    
//    while(1)
//    {
//      TFT.getPixel(p);
//      TFT.locate(0,100);
//      TFT.printf("X: %6d, Y: %6d",p.x,p.y);
//    }
      //  TFT.printf("msg : %s\r\n",get_msg);
//        if(!ret)
//        {
//          TFT.printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
//          TFT.printf("Result: %s\r\n", str);
//        }
//        else
//        {
//          TFT.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
//        }
//        wait(20);
//    }
        
}
