/************************************************/
/*IRQ=pin5    ->   Not used. Leave open         */
/*MISO=pin4   ->   WIZwiki-W7500 SPI_MISO=D12   */
/*MOSI=pin3   ->   WIZwiki-W7500 SPI_MOSI=D11   */
/*SCK=pin2    ->   WIZwiki-W7500 SPI_SCK =D13   */
/*SDA=pin1    ->   WIZwiki-W7500 SPI_CS  =D10   */
/*RST=pin7    ->   WIZwiki-W7500         =D8    */
/************************************************/
                              
#include "mbed.h"
#include "MFRC522.h"

DigitalOut LedGreen(LED1);

MFRC522    RfChip   (D11, D12, D13, D10, D8);

int main(void) {
  printf("starting...\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  printf("initailzed\n");
  
  while (true) {
    LedGreen = 1;

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
    
    LedGreen = 0;

    // Print Card UID
    printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      printf(" %X02", RfChip.uid.uidByte[i]);
    }
    printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
  }
}