#include "mbed.h"

extern "C" {
    #include "uip.h"
    #include "uip_arp.h"
}
#include "tapdev.h"

#define BUF ((struct uip_eth_hdr *)&uip_buf[0])

#ifndef NULL
#define NULL (void *)0
#endif /* NULL */

//DigitalOut myled(LED1);

/* Ethernet Pin configuration
    => /dev-enc28j60/tapdev.cpp
*/

//Serial pc(USBTX, USBRX); // tx, rx
//RawSerial pc(USBTX, USBRX); // tx, rx

int main() {
  //pc.baud(9600);
  //pc.baud(115200);
  
  wait_ms(100);
  
  int i;
  uip_ipaddr_t ipaddr;
  Timer periodic_timer, arp_timer;

  periodic_timer.start();
  arp_timer.start();
  
  /* Initialize the device driver. */ 
  printf("tapdev_init()\n");
  tapdev_init();

  /* Initialize the uIP TCP/IP stack. */
  printf("uip_init()\n");
  uip_init();

  struct uip_eth_addr mac = {UIP_ETHADDR0, UIP_ETHADDR1, UIP_ETHADDR2, UIP_ETHADDR3, UIP_ETHADDR4, UIP_ETHADDR5};
  uip_setethaddr(mac);

  uip_ipaddr(&ipaddr, 192,168,0,12);
  uip_sethostaddr(&ipaddr);
  uip_ipaddr(&ipaddr, 192,168,0,1);
  uip_setdraddr(&ipaddr);
  uip_ipaddr(&ipaddr, 255,255,255,0);
  uip_setnetmask(&ipaddr);

  printf("httpd_init()\n");
  httpd_init();
  
  /*  telnetd_init();*/
  
  /*  hello_world_init();*/

  /*  {
      u8_t mac[6] = {1,2,3,4,5,6};
      dhcpc_init(&mac, 6);
      }*/
  
  /*uip_ipaddr(ipaddr, 127,0,0,1);
  smtp_configure("localhost", ipaddr);
  SMTP_SEND("adam@sics.se", NULL, "uip-testing@example.com",
        "Testing SMTP from uIP",
        "Test message sent by uIP\r\n");*/

  /*
    webclient_init();
    resolv_init();
    uip_ipaddr(ipaddr, 195,54,122,204);
    resolv_conf(ipaddr);
    resolv_query("www.sics.se");*/


  printf("uIP Start.\n");

  while(1) {
    uip_len = tapdev_read();
    if(uip_len > 0) {
      //printf("recv = %d\n", uip_len);
      
      if(BUF->type == UIP_HTONS(UIP_ETHTYPE_IP)) {
        uip_arp_ipin();
        uip_input();
        /* If the above function invocation resulted in data that
           should be sent out on the network, the global variable
           uip_len is set to a value > 0. */
        if(uip_len > 0) {
          uip_arp_out();
          tapdev_send();
        }
      } else if(BUF->type == UIP_HTONS(UIP_ETHTYPE_ARP)) {
        uip_arp_arpin();
        /* If the above function invocation resulted in data that
           should be sent out on the network, the global variable
           uip_len is set to a value > 0. */
        if(uip_len > 0) {
          tapdev_send();
        }
      }

    } else if(periodic_timer.read_ms() >= 500) {
      periodic_timer.reset();
      //printf("periodic_timer tick\n");
      for(i = 0; i < UIP_CONNS; i++) {
        uip_periodic(i);
        /* If the above function invocation resulted in data that
           should be sent out on the network, the global variable
           uip_len is set to a value > 0. */
        if(uip_len > 0) {
          uip_arp_out();
          tapdev_send();
        }
      }

#if UIP_UDP
      for(i = 0; i < UIP_UDP_CONNS; i++) {
        uip_udp_periodic(i);
        /* If the above function invocation resulted in data that
           should be sent out on the network, the global variable
           uip_len is set to a value > 0. */
        if(uip_len > 0) {
          uip_arp_out();
          tapdev_send();
        }
      }
#endif /* UIP_UDP */
      
      /* Call the ARP timer function every 10 seconds. */
      if(arp_timer.read_ms() >= 10000) {
        arp_timer.reset();
        //printf("arp_timer tick\n");
        uip_arp_timer();
      }
    }
  }
  //return 0;
}
/*---------------------------------------------------------------------------*/
void
uip_log(char *m)
{
  printf("uIP log message: %s\n", m);
}
/*---------------------------------------------------------------------------*/
