/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Adam Dunkels <adam@sics.se>
 *
 * $Id: tapdev.c,v 1.8 2006/06/07 08:39:58 adam Exp $
 */

#include "mbed.h"

#include "enc28j60.h"
#include "uip.h"

#if defined(TARGET_LPC1768)
SPI spi(p11, p12, p13); // mosi, miso, sclk
ENC28J60 enc28j60(&spi, p14, p15); // cs, int
#elif defined(TARGET_LPC1114)
SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
ENC28J60 enc28j60(&spi, dp25, dp26); // cs, int
#else
#error no defined tapdev.
#endif

/*---------------------------------------------------------------------------*/
void
tapdev_init(void)
{
	enc28j60.init();

	//enc28j60.regDump();

}
/*---------------------------------------------------------------------------*/
unsigned int
tapdev_read(void)
{
	unsigned int len;
	len = enc28j60.packetReceive(UIP_BUFSIZE, (u8 *)uip_buf);
	return len;
}
/*---------------------------------------------------------------------------*/
void
tapdev_send(void)
{
	enc28j60.packetSend(uip_len, (u8 *)uip_buf);
	
	/*
	if(uip_len <= 40 + UIP_LLH_LEN){
		enc28j60.packetSend(uip_len, (u8 *)uip_buf);
	}else{
		enc28j60.packetSend2(54, (u8 *)uip_buf, uip_len -40 - UIP_LLH_LEN, (u8 *)uip_appdata);
	}
	*/
}
/*---------------------------------------------------------------------------*/
