#ifndef SD_iSDIO_h
#define SD_iSDIO_h

#include "mbed.h"
#include "SDFileSystem.h"
#include "iSDIO_helper.h"

class SD_iSDIO : public SDFileSystem
{
public:
    SD_iSDIO(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name);

    static SD_iSDIO* getInstance();
    uint32_t getSequenceId();

    uint8_t readExtDataPort(uint8_t mio, uint8_t func, uint16_t addr, uint8_t* dst);
    uint8_t readExtMemory(uint8_t mio, uint8_t func, uint32_t addr, uint16_t count, uint8_t* dst);
    uint8_t writeExtDataPort(uint8_t mio, uint8_t func, uint16_t addr, const uint8_t* src);
    uint8_t writeExtMemory(uint8_t mio, uint8_t func, uint32_t addr, uint16_t count, const uint8_t* src);
    uint8_t writeExtMask(uint8_t mio, uint8_t func, uint32_t addr, uint8_t mask, const uint8_t* src);

    uint8_t waitResponse(uint32_t sequenceId);

protected:
    uint8_t readExt(uint32_t arg, uint8_t* src, uint16_t count);
    uint8_t writeExt(uint32_t arg, const uint8_t* src, uint16_t count);

    static SD_iSDIO* instance;
    uint32_t sequenceId;
};

#endif  // SD_iSDIO_h
