#include "mbed.h"
#include "sharp_mlcd.h"
#include "GT20L16J1Y_font.h"
#include "utf8_table.h"

#include <stdlib.h>

/* 
    GT20L16J1Y library test program
*/

DigitalOut led(LED1);

#if defined(TARGET_LPC1768)
C12832 lcd(p5, p7, p6, p8, p11);
GT20L16J1Y_FONT font(p11, p12, p13, p10);
#elif defined(TARGET_LPC11U68)
C12832 lcd(D11, D13, D12, D7, D10);
GT20L16J1Y_FONT font(P0_21, P0_22, P1_20, P0_23);
#elif defined(TARGET_KL46Z) || defined(TARGET_KL25Z)
GT20L16J1Y_FONT font(D11, D12, D13, D3);
sharp_mlcd lcd(D11, D13, D2, D4, D5, "LCD");
#endif

Ticker timer;

void attime()
{
    lcd.attime();
}

#define numOfCharBuffer 40
uint16_t kBuf[numOfCharBuffer];

void draw_string(int offset_x, int offset_y, int width)
{
    int color;
    for(int x=0; x<width*2; x++)
    {
        for(int y=0; y<8; y++)
        {
            if (font.bitmap[x] & (1<<y))
                color = 1;
            else
                color = 0;
            lcd.pixel(x%width + offset_x, y+(8*(x/width)) + offset_y, color);
        }
    }
    //lcd.copy_to_lcd();
}

int int_compar(const uint16_t *a, const uint16_t *b)
{
    if (*a < *b)
        return (-1);
    else if (*a > *b)
        return (1);
    else
        return (0);
}

int conv_utf8(char* utfBuffer, uint16_t* kutenBuffer)
{
    int ret;
    uint16_t key, *index, *pBuf;
    char *uBuf;
    
    uBuf = utfBuffer;
    pBuf = kutenBuffer;
    ret = 0;

    while (uBuf[0] != 0) {
        if (uBuf[0] >= 0x20 && uBuf[0] < 0x80) {
            // in case of ASCII
            *pBuf++ = (uint16_t)uBuf[0];
            uBuf += 1;
            ret++;
            continue;
        }
        else if ( (uBuf[0]&0xF0) == 0xE0) {
            // extract valid bits of UTF-8
            key = ((uBuf[0] & 0x000F) << 12) | ((uBuf[1] & 0x003F) << 6) | (uBuf[2] & 0x003F);
            uBuf += 3;
        }
        else if ( (uBuf[0]&0xE0) == 0xC0) {
            // extract valid bits of UTF-8
            key = ((uBuf[0] & 0x001F) << 6) | (uBuf[1] & 0x003F);
            uBuf += 2;
        }
        else {
            uBuf += 1;
            continue;
        }
        
        // search UTF-8 code from utf8_key[] table to get index of Kuten table
        index = (uint16_t *)bsearch(&key, utf8_key, (sizeof(utf8_key) / sizeof(utf8_key[0])), sizeof(uint16_t), (int (*)(const void *, const void *))int_compar);
        if (index != 0) {
            // get Kuten code
            *pBuf = utf8_value[index - utf8_key];
        } else {
            *pBuf = 0;
        }

        pBuf++;
        ret++;
    }
    *pBuf = 0;
    
    return ret;
}

void draw_utf8(int offset_x, int offset_y, char *buf_u)
{
    int len = conv_utf8(buf_u, kBuf);
    int xpos = 0;
    
    for(int i = 0; i < len; i++) {
        int width = font.read_kuten(kBuf[i]);
        draw_string(xpos + offset_x, offset_y, width);
        xpos += width;
    }
}

void draw_test1()
{
    char str[11];
    int ypos = 0;
    int p = 0x20;
    for(int j = 0; j < 14; j++) {
        sprintf(str, "%8X:", p);
        draw_utf8(0, ypos, str);
        int xpos = 80;
        for(int i = 0; i < 16; i++) {
            int width = font.read_kuten(0x0000 + p++);
            draw_string(xpos, ypos, width);
            xpos += width;
        }
        ypos += 16;
        if(ypos > 240 - 16) ypos = 0;
        lcd.copy_to_lcd();
    }
}

void draw_test2()
{
    char str[11];
    int ypos = 0;
    unsigned long p = 0x00;
    for(int j = 0; j < 150; j++) {
        sprintf(str, "%8X:", p);
        draw_utf8(0, ypos, str);
        int xpos = 80;
        for(int i = 0; i < 16; i++) {
            font.read_direct(p);
            p += 32;
            draw_string(xpos, ypos, 16);
            xpos += 16;
        }
        ypos += 16;
        if(ypos > 240 - 16) ypos = 0;
        lcd.copy_to_lcd();
    }
}

void draw_test3()
{
    char str[11];
    int ypos = 0;
    unsigned long p = 0x3E7E0;
    for(int j = 0; j < 15; j++) {
        sprintf(str, "%8X:", p);
        draw_utf8(0, ypos, str);
        int xpos = 80;
        for(int i = 0; i < 32; i++) {
            font.read_direct(p);
            p += 16;
            draw_string(xpos, ypos, 8);
            xpos += 8;
        }
        ypos += 16;
        if(ypos > 240 - 16) ypos = 0;
        lcd.copy_to_lcd();
    }
}

int main()
{
    led = 0;

    printf("start\r\n");

    timer.attach(attime, 0.5);

    lcd.setmode(NORMAL);
    lcd.set_auto_up(0);

    lcd.cls();

    draw_utf8(0, 0,  "進捗どうですか??");
    draw_utf8(0, 16, "mbedで日本語表示");

    draw_utf8(0, 48, "｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿ");
    draw_utf8(0, 64, "ﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ");

    draw_utf8(0, 96, "エンベッド -> ｴｪｪｪｪﾝﾍﾞｯﾄﾞ!");

    draw_utf8(0, 112, "顔文字１ -> (;´Д｀)ゞ");
    draw_utf8(0, 128, "顔文字２ -> (´・ω・`)");
    draw_utf8(0, 144, "顔文字３ -> (∩´∀｀)∩");
    draw_utf8(0, 160, "顔文字４ -> (･･)/~");

    lcd.copy_to_lcd();

    wait(5);

    lcd.cls();
    draw_test1();
    lcd.copy_to_lcd();

    wait(5);

    lcd.cls();
    draw_test2();
    lcd.copy_to_lcd();

    wait(5);

    lcd.cls();
    draw_test3();
    lcd.copy_to_lcd();

    printf("end\r\n");

    while(1) {
        led = !led;
        wait(1.0);
    }
}
