#include "mbed.h"
#include "XBeeWiFi.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"


#define SECURITY SECURITY_WPA2
#define SSID "XBEEWIFI"
#define PASSPHRASE "PASSWORD"
/*
#define SECURITY SECURITY_OPEN
#define SSID "XBEEWIFI"
#define PASSPHRASE ""
*/
#define HTTP_PORT 80
#define HTTP_SRC_PORT 10080
#define HTTP_TIMEOUT 5000 // ms
#define METHOD_GET 0
#define METHOD_POST 1

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC11U24)
XBeeWiFi xbee(p11, p12, p13, p14, p15, p16);    // mosi, miso, sclk, ssel, attn, reset
#elif defined(TARGET_LPC1114)
XBeeWiFi xbee(dp2, dp1, dp6, dp9, dp10, dp11);  // mosi, miso, sclk, ssel, attn, reset
#endif

int init_wifi (int timeout) {
    int i, r;

    pc.printf("reset\r\n");
    r = xbee.reset();
    if (r < 0) {
        pc.printf("error reset %d\r\n", r);
        return -1;
    }

    xbee.getWiResponse(MODEM_STATUS_RESPONSE, 5000);    

    r = xbee.setup(SECURITY, SSID, PASSPHRASE);
    if (r < 0) {
        pc.printf("error setup %d\r\n", r);
        return -1;
    }

    for (i = 0; i < timeout; i ++) {
        wait(1);
        r = xbee.getStatus();
        pc.printf("status %02x: ", r);    
        switch (r) {
        case JOINED_AP:
            pc.printf("Successfully joined an access point.\r\n");
            return 0;
        case INITIALIZATION:
            pc.printf("WiFi initialization in progress.\r\n");
            break;
        case SSID_NOT_FOUND:
            pc.printf("SSID not found.\r\n");
            return -1;
        case SSID_NOT_CONFIGURED:
            pc.printf("SSID not configured.\r\n");
            return -1;
        case JOIN_FAILED:
            pc.printf("SSID join failed.\r\n");
            return -1;
        case WAITING_IPADDRESS:
            pc.printf("Waiting for IP configuration.\r\n");
            break;
        case WAITING_SOCKETS:
            pc.printf("Listening sockets are being set up.\r\n");
            break;
        case SCANNING_SSID:
            pc.printf("Currently scanning for SSID.\r\n");
            break;
        default:
            pc.printf("\r\n");
            break;
        }
    }
    return -1;
}


int httpRequest (int method, Host *host, char *uri, char *head, char *body) {
    Timer timeout;
    char buf[1500], tmp[40];
    int r, len;
    IPv4TransmitRequest httpRequest;
    AtCommandRequest atRequest;
    AtCommandResponse atResponse;
    IPV4RxFrame httpResponse;
    IpAddr ipaddr;

    // connect
    if (host->getIp().isNull()) {
        return -1;
    }
    if (! host->getPort()) {
        host->setPort(HTTP_PORT);
    }

    // create request
    if (method == METHOD_POST) {
        strcpy(buf, "POST ");
    } else {
        strcpy(buf, "GET ");
    }
    strcat(buf, uri);
    strcat(buf, " HTTP/1.1\r\nHost: ");
    strcat(buf, host->getName());
    strcat(buf, "\r\n");
    strcat(buf, "Connection: close\r\n");
    if (head) {
        strcat(buf, head);
    }
    if (method == METHOD_POST) {
        sprintf(tmp, "Content-Length: %d\r\n", strlen(body));
        strcat(buf, tmp);
    }
    strcat(buf, "\r\n");

    // send HTTP request
    len = strlen(buf);
    ipaddr = host->getIp();
    httpRequest.setAddress(ipaddr);
    httpRequest.setDstPort(host->getPort());
    httpRequest.setSrcPort(HTTP_SRC_PORT);
    httpRequest.setProtocol(PROTOCOL_TCP);
    httpRequest.setPayload((uint8_t*)buf);
    httpRequest.setPayloadLength(len);
    httpRequest.setFrameId(xbee.getNextFrameId());
    xbee.send(httpRequest);
    r = xbee.getWiResponse(TX_STATUS_RESPONSE, httpRequest.getFrameId());
    pc.printf("wifi TX: %d\r\n", r);
    if (r < 0) return -1;

    // wait responce
    timeout.reset();
    timeout.start();
    while (timeout.read_ms() < HTTP_TIMEOUT) {
        // recv HTTP request
        r = xbee.getWiResponse(IPv4_RX_FRAME, 0, 3000);
        pc.printf("wifi RX: %d\r\n", r);
        if (r >= 0) {
            timeout.reset();
            xbee.getResponse().getAtCommandResponse(httpResponse);
            pc.printf("\r\n--- recv %d ---\r\n", httpResponse.getDataLength());
            strncpy(buf, (char*)httpResponse.getData(), httpResponse.getDataLength());
            buf[httpResponse.getDataLength()] = 0;
            pc.printf(buf);
        }
    }
    timeout.stop();
    return 0;
}

int main() {
//    int i;
    IpAddr ipaddr, netmask, gateway, nameserver;
    Host host;

//    xbee.begin(115200);
//    xbee.baud(921000);
    pc.baud(9600);
    pc.printf("XBee WiFi test\r\n");

    if (init_wifi(20)) {
        pc.printf("XBee error\r\n");
        return -1;
    }

    xbee.getAddress(ipaddr, netmask, gateway, nameserver);
    pc.printf("IP address %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);
    if (ipaddr.isNull()) {
        pc.printf("not configure\r\n");
        return -1;
    }

/*
    // DNS lookup 
    // *** Note: wifi is turned off when XBee send/recv the port 53 udp packet.
    //           XBee wifi --> request --> DNS server (wifi OK)
    //           DNS server --> responce --> XBee wifi (wifi turned off)
    //           why ??
    nameserver = gateway;
//    nameserver = IpAddr(12,34,56,78);
    pc.printf("resolver %d.%d.%d.%d\r\n", nameserver[0], nameserver[1], nameserver[2], nameserver[3]);
    xbee.setNameserver(nameserver);
    i = xbee.getHostByName("mbed.org", ipaddr);
    if (i) {
        pc.printf("error resolv %d\r\n", i);
    } else {
        pc.printf("resolv address %d.%d.%d.%d\r\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3]);
    }
*/
    // HTTP request
    wait(1);
    host.setIp(IpAddr(54,243,166,106));
    host.setName("httpbin.org");
    httpRequest(METHOD_GET, &host, "/get", "", "");

    pc.printf("done.\r\n");
    while(1);

}
