#include "mbed.h"
#include "WIZ820ioInterface.h"
#include "mbed_rpc.h"
#include "HTTPD.h"

SPI *spi;
WIZ820ioInterface *eth;
HTTPD *httpd;

#if defined(TARGET_LPC1768)
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

#elif defined(TARGET_LPC1114)
Serial pc(dp16,dp15);

#endif

const char* const index_page =
    "<html>"
    "<body>"
    "<h1>Tiny HTTP Server</h1>"
    "<h2>RPC</h2>"
    "<a href=\"/rpc/DigitalOut/new%20LED1%20myled\">/rpc/DigitalOut/new LED1 myled</a><br><br>"
    "<a href=\"/rpc/myled/write%200\">/rpc/myled/write 0</a><br><br>"
    "<a href=\"/rpc/myled/write%201\">/rpc/myled/write 1</a><br><br>"
    "</body>"
    "</html>";

void callback_static (int id) {
    char buf[256];

    strcpy(buf, httpd->getFilename(id));
    printf("static %d %s\r\n", id, buf);

    if (strcmp(buf, "") == 0 || strcmp(buf, "index.html") == 0) {
        httpd->send(id, index_page, strlen(index_page), "Content-Type: text/html\r\n");
    } else {
        httpd->httpdError(id, 404);
    }
}

void callback_cgi (int id) {
    int i, n;
    char buf[256];

    strcpy(buf, httpd->getFilename(id));
    strcat(buf, "\r\n");
    strcat(buf, httpd->getQueryString(id));
    strcat(buf, "\r\n");
    n = strlen(buf);

    i = httpd->receive(id, &buf[n], sizeof(buf) - n);
    if (i < 0) return;
    i += n;
    buf[i] = 0;

    printf("CGI %d %s\r\n", id, buf);
    httpd->send(id, buf, i, "Content-Type: text/plain\r\n");
}

void callback_ws (int id) {
    int i;
    char buf[256];

    i = httpd->receive(id, buf, sizeof(buf));
    if (i < 0) return;
    buf[i] = 0;

    printf("WS %d %s\r\n", id, buf);
    httpd->sendWebsocket(id, buf, i);
}

void callback_rpc (int id) {
    char buf[40], outbuf[40];

    strcpy(buf, "/");
    httpd->urldecode(httpd->getFilename(id), &buf[1], sizeof(buf) - 2);
    RPC::call(buf, outbuf);

    printf("RPC id %d '%s' '%s'\r\n", id, buf, outbuf);
    httpd->send(id, outbuf, strlen(outbuf), "Content-Type: text/plain\r\n");
}

int main () {
    int ret;

    //pc.baud(115200);
    pc.baud(9600);
    printf("HTTP Server...\r\n");

#if defined(TARGET_LPC1768)
    spi = new SPI(p5, p6, p7); // mosi, miso, sclk
    spi->frequency(4000000); // 4MHz
    eth = new WIZ820ioInterface(spi, p21, p22); // spi, cs, reset
#elif defined(TARGET_LPC1114)
    spi = new SPI(dp2, dp1, dp6); // mosi, miso, sclk
    spi->frequency(4000000); // 4MHz
    eth = new WIZ820ioInterface(spi, dp25, dp26); // spi, cs, reset
#endif

    eth->init(); //Use DHCP
//    eth->init("192.168.1.2", "255.255.255.0", "192.168.1.1");

    ret = eth->connect();
    if (ret) {
        printf("connect error %d", ret);
        return -1;
    }
    printf("IP Address is %s\r\n", eth->getIPAddress());

//    RPC::add_rpc_class<RpcAnalogIn>();
//    RPC::add_rpc_class<RpcAnalogOut>();
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcPwmOut>();

    httpd = new HTTPD;
    httpd->attach("/cgi-bin/", &callback_cgi);
    httpd->attach("/ws/", &callback_ws);
    httpd->attach("/rpc/", &callback_rpc);
#if defined(TARGET_LPC1768)
    httpd->attach("/local/", "/local/");
#endif
    httpd->attach("/", &callback_static);
    httpd->start(80);
    printf("httpd ready\r\n");
#if defined(TARGET_LPC1768)
    led1 = 1;
#endif

    for (;;) {
        httpd->poll();
        
        //printf("poll-loop\r\n");
    }
}
