#include "mbed.h"
#include "EthernetInterface.h"
#include "UDPSocket.h"

EthernetInterface eth;
UDPSocket udpClient;
Endpoint epServer;

Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

const char SENDDATA[] = "testtesttesttesttesttesttesttest";

int main()
{
    pc.printf("eth.init() dhcp return = %d\n", eth.init());
    //pc.printf("eth.init() static return = %d\n", eth.init("192.168.0.38", "255.255.255.0", "192.168.0.38"));

    eth.connect();
    udpClient.init();
    
    epServer.set_address("239.168.1.1", 38383);
    pc.printf("IP Address = %s\n", eth.getIPAddress());

    while(1) {
        for(int i=16; i<=sizeof(SENDDATA); i++) {
            myled1 = !myled1;
            udpClient.sendTo(epServer, (char * )&SENDDATA, i);
            wait(0.25);
        }
        myled2 = !myled2;
        wait(2);
    }
}
