#include "mbed.h"
#include "sharp_mlcd.h"

#include "Arial12x12.h"

#if defined(TARGET_NUCLEO_L152RE)
sharp_mlcd lcd("LCD");
Serial pc(USBTX, USBRX);
#else
sharp_mlcd lcd(D11, D13, D2, D4, D5, "LCD");
Serial pc(USBTX, USBRX);
#endif

const static 
char mbedlogo128x48[768]
= {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc7,0x83,0xe0,0x3c,0x7c,0x00,0x7e,0x00,0x3e,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xdf,0xef,0xf8,0x3d,0xfe,0x01,0xff,0x80,0x7f,0xbc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xff,0xff,0xf8,0x3f,0xff,0x03,0xff,0xc0,0xff,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xf1,0xfc,0x7c,0x3f,0x0f,0x87,0xc3,0xe1,0xf0,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xe0,0xf8,0x3c,0x3e,0x07,0x87,0x81,0xe1,0xe0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0xe3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0x03,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3e,0x03,0xcf,0x00,0x03,0xc0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3e,0x07,0x87,0x80,0x01,0xe0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3f,0x0f,0x87,0xc1,0xc1,0xf0,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3f,0xff,0x03,0xff,0xf0,0xff,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3d,0xfe,0x01,0xff,0xe0,0x7f,0xbc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0xfc,0x00,0x7f,0x00,0x3f,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


const static struct Bitmap logo = {
  128,
  48,
  16,
  (char*)mbedlogo128x48,
};

const char target[] = 
#if defined(TARGET_NUCLEO_L152RE)
"STM32 Nucleo L152RE"
#elif defined(TARGET_KL46Z)
"Freescale FRDM-KL46Z"
#elif defined(TARGET_KL25Z)
"Freescale FRDM-KL25Z"
#elif defined(TARGET_KL05Z)
"Freescale FRDM-KL05Z"
#else
"????"
#endif
;

#include "picture.h"
extern const uint8_t picture[];
const struct Bitmap pic = {
  400,
  240,
  400/8,
  (char*)picture,
};

Ticker timer;

void attime() {
    lcd.attime();
}

static const unsigned char  logo16_glcd_bmp[] =
{ 0x00, 0xc0, // B00000000, B11000000,
  0x01, 0xc0, // B00000001, B11000000,
  0x01, 0xc0, // B00000001, B11000000,
  0x03, 0xe0, // B00000011, B11100000,
  0xf3, 0xe0, // B11110011, B11100000,
  0xfe, 0xf8, // B11111110, B11111000,
  0x7e, 0xff, // B01111110, B11111111,
  0x33, 0x9f, // B00110011, B10011111,
  0x1f, 0xfc, // B00011111, B11111100,
  0x0d, 0x70, // B00001101, B01110000,
  0x1b, 0xa0, // B00011011, B10100000,
  0x3f, 0xe0, // B00111111, B11100000,
  0x3f, 0xf0, // B00111111, B11110000,
  0x7c, 0xf0, // B01111100, B11110000,
  0x70, 0x70, // B01110000, B01110000,
  0x00, 0x30 }; // B00000000, B00110000 };
  
const static struct Bitmap snow = {
  16,
  16,
  2,
  (char*)logo16_glcd_bmp,
};

#define NUMFLAKES 48
#define XPOS 0
#define YPOS 1
#define DELTAY 2

void testdrawbitmap(struct Bitmap bitmap) {
  int16_t icons[NUMFLAKES][3];
  srand((unsigned int)time(NULL)); // srandom(666);     // whatever seed
  int i;
 
  // initialize
  for (uint8_t f=0; f< NUMFLAKES; f++) {
    icons[f][XPOS] = (rand() % (lcd.width()  + bitmap.xSize)) - bitmap.xSize / 2;
    icons[f][YPOS] = (rand() % (lcd.height() + bitmap.ySize)) - bitmap.ySize;
    icons[f][DELTAY] = rand() % 5 + 2;
#if 0
    Serial.print("x: ");
    Serial.print(icons[f][XPOS], DEC);
    Serial.print(" y: ");
    Serial.print(icons[f][YPOS], DEC);
    Serial.print(" dy: ");
    Serial.println(icons[f][DELTAY], DEC);
#endif
  }
  lcd.setmode(XOR);
  i = 0;
  while (1) {
    // draw each icon
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      lcd.print_bm(bitmap, icons[f][XPOS], icons[f][YPOS], 1); 
    }
    lcd.copy_to_lcd();
    //wait_ms(200); // delay(200);
    
    // then erase it + move it
    for (uint8_t f=0; f< NUMFLAKES; f++) {
      lcd.print_bm(bitmap, icons[f][XPOS], icons[f][YPOS], 1); 
      // move it
      icons[f][YPOS] += icons[f][DELTAY];
      // if its gone, reinit
      if (icons[f][YPOS] > lcd.height()) { // display.height()) {
        icons[f][XPOS] = (rand() % (lcd.width() + bitmap.xSize)) - bitmap.xSize / 2;
        icons[f][YPOS] = -bitmap.ySize;
        icons[f][DELTAY] = rand() % 5 + 2;
      }
    }
    if (i++ > 100) break;
   }
   lcd.setmode(NORMAL);
}


void testdrawline() {  
  for (int16_t i=0; i<lcd.width(); i+=7) {
    lcd.line(0, 0, i, lcd.height()-1, 1);
    lcd.copy_to_lcd();
  }
  for (int16_t i=1; i<lcd.height(); i+=7) {
    lcd.line(0, 0, lcd.width()-1, i, 1);
    lcd.copy_to_lcd();
  }
  wait_ms(150); // delay(150);
#if 0
  lcd.cls();
  for (int16_t i=0; i<lcd.width(); i+=4) {
    lcd.line(0, lcd.height()-1, i, 0, 1);
    lcd.copy_to_lcd();
  }
  for (int16_t i=lcd.height()-1; i>=0; i-=4) {
    lcd.line(0, lcd.height()-1, lcd.width()-1, i, 1);
    lcd.copy_to_lcd();
  }
  wait_ms(150); // delay(150);
  
  lcd.cls();
  for (int16_t i=lcd.width()-1; i>=0; i-=4) {
    lcd.line(lcd.width()-1, lcd.height()-1, i, 0, 1);
    lcd.copy_to_lcd();
  }
  for (int16_t i=lcd.height()-1; i>=0; i-=4) {
    lcd.line(lcd.width()-1, lcd.height()-1, 0, i, 1);
    lcd.copy_to_lcd();
  }
  wait_ms(150); // delay(150);

  lcd.cls();
  for (int16_t i=0; i<lcd.height(); i+=4) {
    lcd.line(lcd.width()-1, 0, 0, i, 1);
    lcd.copy_to_lcd();
  }
  for (int16_t i=0; i<lcd.width(); i+=4) {
    lcd.line(lcd.width()-1, 0, i, lcd.height()-1, 1); 
    lcd.copy_to_lcd();
  }
  wait_ms(250);
#endif
}

int main() {
    pc.printf("%s\r\n", target);
    timer.attach(attime, 0.5);
    lcd.setmode(NORMAL);
    // lcd.set_font((unsigned char*)Arial24x23);
    lcd.set_font((unsigned char*)Arial12x12);
    lcd.set_auto_up(0);
    while (1) {
        lcd.cls();
        lcd.locate(0,0);
        pc.printf("\r\n  %s!\r\n  This is Sharp Memory LCD demo.", target);
        lcd.printf("\r\n  %s!\r\n  This is Sharp Memory LCD demo.", target);
        lcd.printf("\r\n\r\n    columns: %d  rows: %d", lcd.columns(), lcd.rows());

        lcd.print_bm(logo, 260, 178, 1);
        lcd.locate(260,172);
        lcd.printf("Powerd by");

        lcd.copy_to_lcd();

        wait_ms(1000);
        lcd.line(0, 0, lcd.width()-1, 0, 1);
        lcd.copy_to_lcd();
        
        wait_ms(1000);
        lcd.line(lcd.width()-1, 0, lcd.width()-1, lcd.height()-1, 1);
        lcd.copy_to_lcd();
        
        wait_ms(1000);
        lcd.line(0, lcd.height()-1, lcd.width()-1, lcd.height()-1, 1);
        lcd.copy_to_lcd();
        
        wait_ms(1000);
        lcd.line(0, 0, 0, lcd.height()-1, 1);
        lcd.copy_to_lcd();

        wait_ms(3000);
        
        lcd.cls();
        
        lcd.locate(0,0);
        lcd.printf("Copyright (c) 2014 Masato YAMANISHI or more authors, MIT License\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("Permission is hereby granted, free of charge, to any person obtaining a copy of this software "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("and associated documentation files (the \"Software\"), to deal in the Software without restriction, "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("including without limitation the rights to use, copy, modify, merge, publish, distribute, "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("furnished to do so, subject to the following conditions:\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("The above copyright notice and this permission notice shall be included in all copies or "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("substantial portions of the Software.\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("\r\n"); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, "); lcd.copy_to_lcd(); wait_ms(50);
        lcd.printf("OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE."); lcd.copy_to_lcd(); wait_ms(50);
        
        lcd.copy_to_lcd();
        
        wait_ms(5000);
        
        lcd.print_bm(pic, 0, 0, 0); 
        lcd.copy_to_lcd();

        wait_ms(3000);
        
        for (int i=0; i<240+1; i+=2) {
            lcd.copy_to_lcd(i);
        }
        
        wait_ms(5000);
        
        lcd.cls();
        testdrawline();
        
        wait_ms(5000);
        
        lcd.cls();
        testdrawbitmap(snow);

        wait_ms(5000);
    }
}
