#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "NTPClient.h"

#define WIFI_SSID           "mbed_ap"
#define WIFI_SECUTIRY_KEY   "password1234"
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface wifi( p9, p10, NC, NC, p30 );
Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"
#else
#error no defined pin.
#endif

NTPClient ntp;
char str[32];

int main()
{
    pc.baud( 115200 );
    pc.printf("----------------\n");
    pc.printf("Murata TypeYD - NTPClient example\n");

    int ret = wifi.init();
    if (!ret) {
        printf("Initialized\n");
        //printf("Initialized, MAC: %s\n", wifi.getMACAddress());
    } else {
        printf("Error wifi.init() - ret = %d\n", ret);
        return -1;
    }

    wait(0.5);

    ret = wifi.disconnect();

    wait(0.5);

    ret = wifi.getFWVersion((unsigned char *)str);
    if (!ret) {
        printf("Firmware version: %s\n", str);
    } else {
        printf("Error wifi.getFWVersion() - ret = %d\n", ret);
        return -1;
    }

    wait(0.5);

    ret = wifi.connect( WIFI_SSID, strlen(WIFI_SSID)
                        , WIFI_SECURITY_TYPE
                        , WIFI_SECUTIRY_KEY, strlen(WIFI_SECUTIRY_KEY) );
    if (!ret) {
        printf("Connected\n");
        /*
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               wifi.getIPAddress(), wifi.getNetworkMask(), wifi.getGateway());
        */
    } else {
        printf("Error wifi.connect() - ret = %d\n", ret);
        return -1;
    }

    // Use DHCP
    wifi.setIPConfig( true );
    // Use Static IP
    //wifi.setIPConfig( false, "192.168.0.48", "255.255.255.0", "192.168.0.1" );

    wait(0.5);

    printf("\nTrying to update time...\n");
    //ret = ntp.setTime("pool.ntp.org");    // Do not work (SNICInterface bug)
    //ret = ntp.setTime("ntp.nict.jp");     // Do not work (SNICInterface bug)
    ret = ntp.setTime("133.243.238.164");   // = ntp.nict.jp
    if (!ret) {
        printf("Set time successfully\n");
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\n", ctime(&ctTime));
    } else {
        printf("Error\n");
    }

    ret = wifi.disconnect();
    if (!ret) {
        printf("Disconnected\n");
    } else {
        printf("Error wifi.disconnect() - ret = %d\n", ret);
    }

    while(1) {
    }
}
