#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "HTTPClient.h"

#define WIFI_SSID           "mbed_ap"
#define WIFI_SECUTIRY_KEY   "password1234"
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface wifi( p9, p10, NC, NC, p30 );
Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"
#else
#error no defined pin.
#endif

HTTPClient http;
char str[512];

int main()
{
    pc.baud( 115200 );
    pc.printf("----------------\n");
    pc.printf("Murata TypeYD - HTTPClient example\n");

    int ret = wifi.init();
    if (!ret) {
        printf("Initialized\n");
        //printf("Initialized, MAC: %s\n", wifi.getMACAddress());
    } else {
        printf("Error wifi.init() - ret = %d\n", ret);
        return -1;
    }

    wait(0.5);

    ret = wifi.disconnect();

    wait(0.5);

    ret = wifi.getFWVersion((unsigned char *)str);
    if (!ret) {
        printf("Firmware version: %s\n", str);
    } else {
        printf("Error wifi.getFWVersion() - ret = %d\n", ret);
        return -1;
    }

    wait(0.5);

    ret = wifi.connect( WIFI_SSID, strlen(WIFI_SSID)
                        , WIFI_SECURITY_TYPE
                        , WIFI_SECUTIRY_KEY, strlen(WIFI_SECUTIRY_KEY) );
    if (!ret) {
        printf("Connected\n");
        /*
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               wifi.getIPAddress(), wifi.getNetworkMask(), wifi.getGateway());
        */
    } else {
        printf("Error wifi.connect() - ret = %d\n", ret);
        return -1;
    }

    // Use DHCP
    wifi.setIPConfig( true );
    // Use Static IP
    //wifi.setIPConfig( false, "192.168.0.48", "255.255.255.0", "192.168.0.1" );

    wait(0.5);

    // GET data
    {
        printf("\nTrying to GET request...\n");
        ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", str, sizeof(str));
        if (!ret) {
            printf("Page fetched successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }

    // POST data
    {
        HTTPMap map;
        HTTPText inText(str, sizeof(str));
        map.put("Hello", "World");
        map.put("test", "1234");

        printf("\nTrying to POST request...\n");
        ret = http.post("http://httpbin.org/post", map, &inText);
        if (!ret) {
            printf("Executed POST successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }

    // PUT data
    {
        strcpy(str, "This is a PUT test!");
        HTTPText outText(str);
        HTTPText inText(str, sizeof(str));

        printf("\nTrying to PUT request...\n");
        ret = http.put("http://httpbin.org/put", outText, &inText);
        if (!ret) {
            printf("Executed PUT successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }

    // DELETE data
    {
        HTTPText inText(str, sizeof(str));

        printf("\nTrying to DELETE request...\n");
        ret = http.del("http://httpbin.org/delete", &inText);
        if (!ret) {
            printf("Executed DELETE successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }

    printf("\n");

    ret = wifi.disconnect();
    if (!ret) {
        printf("Disconnected\n");
    } else {
        printf("Error wifi.disconnect() - ret = %d\n", ret);
    }

    while(1) {
    }
}
