/* HTTPPostText.cpp */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "HTTPPostText.h"

#include <cstring>

#define OK 0

using std::memcpy;
using std::strncpy;
using std::strlen;

HTTPPostText::HTTPPostText(char* str) : HTTPText(str)
{

}

HTTPPostText::HTTPPostText(char* str, size_t size) : HTTPText(str, size)
{

}

//IHTTPDataIn
/*virtual*/ int HTTPPostText::getDataType(char* type, size_t maxTypeLen) //Internet media type for Content-Type header
{
  strncpy(type, "application/x-www-form-urlencoded", maxTypeLen-1);
  type[maxTypeLen-1] = '\0';
  return OK;
}

//IHTTPDataOut
/*virtual*/ void HTTPPostText::setDataType(const char* type) //Internet media type from Content-Type header
{

}
