#ifndef MBED_OAUTH4TW_H
#define MBED_OAUTH4TW_H

#include "mbed.h"
#include "HTTPClient.h"
#include <vector>
#include <string>

class OAuth4Tw
{
public:
    OAuth4Tw(const char *c_key, const char *c_secret,
             const char *t_key, const char *t_secret);

    static std::string url_escape(const char *str);

    HTTPResult get(const char *url, IHTTPDataIn* response, int timeout = HTTP_CLIENT_DEFAULT_TIMEOUT);

    HTTPResult post(const char *url, IHTTPDataIn* response, int timeout = HTTP_CLIENT_DEFAULT_TIMEOUT);
    HTTPResult post(const char *url, std::vector<std::string> *postdata, IHTTPDataIn* response, int timeout = HTTP_CLIENT_DEFAULT_TIMEOUT);

private:
    const char *consumer_key;
    const char *consumer_secret;
    const char *token_key;
    const char *token_secret;
};

#endif
