#include "OAuth4Tw.h"
#include "mbed.h"
#include "twicpps/oauth.h"

#include <HTTPClient.h>
#include "HTTPPostText.h"

OAuth4Tw::OAuth4Tw(const char *c_key, const char *c_secret,
                   const char *t_key, const char *t_secret)
    :consumer_key(c_key),
     consumer_secret(c_secret),
     token_key(t_key),
     token_secret(t_secret) { }

std::string OAuth4Tw::url_escape(const char *str)
{
    return oauth_url_escape(str);
}

HTTPResult OAuth4Tw::get(const char *url, IHTTPDataIn *response, int timeout /*= HTTP_CLIENT_DEFAULT_TIMEOUT*/)
{
    std::string req_url;

    req_url = oauth_sign_url2(url, NULL, OA_HMAC, 0,
                              consumer_key, consumer_secret,
                              token_key, token_secret);

    HTTPClient http;
    HTTPResult r = http.get(req_url.c_str(), response);

    return r;
}

HTTPResult OAuth4Tw::post(const char *url, IHTTPDataIn *response, int timeout /*= HTTP_CLIENT_DEFAULT_TIMEOUT*/)
{
    std::string req_url;
    std::string postargs;

    req_url = oauth_sign_url2(url, &postargs, OA_HMAC, 0,
                              consumer_key, consumer_secret,
                              token_key, token_secret);

    const char *poststr = postargs.c_str();

    HTTPClient http;
    HTTPPostText request((char *)poststr, strlen(poststr) + 1);
    HTTPResult r = http.post(req_url.c_str(), request, response);

    return r;
}

HTTPResult OAuth4Tw::post(const char *url, std::vector<std::string> *postdata, IHTTPDataIn *response, int timeout /*= HTTP_CLIENT_DEFAULT_TIMEOUT*/)
{
    std::string req_url;
    std::string postargs;

    {
        std::vector<std::string> argv;
        argv.reserve(postdata->size()+8);

        oauth_split_post_paramters(url, &argv, 0);
        for (int i=0; i<postdata->size(); i++) {
            argv.push_back(postdata->at(i));
        }

        req_url = oauth_sign_array2(&argv, &postargs, OA_HMAC, 0,
                                    consumer_key, consumer_secret,
                                    token_key, token_secret);

#if 0
        for (int i=0; i<argv.size(); i++) {
            printf("param[%d]: %s\n", i, argv.at(i).c_str());
        }
#endif
    }

    const char *poststr = postargs.c_str();

    HTTPClient http;
    HTTPPostText request((char *)poststr, strlen(poststr) + 1);
    HTTPResult r = http.post(req_url.c_str(), request, response);

    return r;
}
