#include "mbed.h"
//#include "EthernetInterface.h"
#include "WIZ820ioInterface.h"
#include "NTPClient.h"

//EthernetInterface eth;
#if defined(TARGET_LPC1114)
SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
WIZ820ioInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
SPI spi(p11, p12, p13); // mosi, miso, sclk
WIZ820ioInterface eth(&spi, p14, p15); // spi, cs, reset

#endif

NTPClient ntp;

int main() 
{
    int ret = eth.init(); //Use DHCP
    if (!ret)
    {
      printf("Initialized, MAC: %s\n", eth.getMACAddress());
    }
    else
    {
      printf("Error eth.init() - ret = %d\n", ret);
      return -1;
    }

    ret = eth.connect();
    if (!ret)
    {
      printf("Connected, IP: %s, MASK: %s, GW: %s\n",
        eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }
    else
    {
      printf("Error eth.connect() - ret = %d\n", ret);
      return -1;
    }

   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
   
    eth.disconnect();  

    while(1) {
    }
}
