#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

EthernetInterface eth;
NTPClient ntp;

int main()
{
    int ret = eth.init(); //Use DHCP
    if (!ret) {
        printf("Initialized, MAC: %s\n", eth.getMACAddress());
    } else {
        printf("Error eth.init() - ret = %d\n", ret);
        return -1;
    }

    ret = eth.connect();
    if (!ret) {
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        printf("Error eth.connect() - ret = %d\n", ret);
        return -1;
    }


    printf("Trying to update time...\n");

    time_t ctTime;
    NTPResult result;

    while(1) {
        result = ntp.setTime("pool.ntp.org");
        //result = ntp.setTime("pool.ntp.org", NTP_DEFAULT_PORT, 2000);

        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC): %s\n", ctime(&ctTime));
            break;
        }

        switch (result) {
            case NTP_CONN:      ///<Connection error
                printf("Connection error\n");
                break;
            case NTP_TIMEOUT:   ///<Connection timeout
                printf("Connection timeout\n");
                break;
            case NTP_PRTCL:     ///<Protocol error
                printf("Protocol error\n");
                break;
            case NTP_DNS:       ///<Could not resolve name
                printf("Could not resolve name\n");
                break;
            default:
                printf("Error result=%d\n", result);
                return -1;
        }

        wait(5);
    }


    ret = eth.disconnect();
    if (!ret) {
        printf("Disconnected\n");
    } else {
        printf("Error eth.disconnect() - ret = %d\n", ret);
    }


    while(1) {
    }
}
