#include "mbed.h"
//#include "EthernetInterface.h"
#include "WIZ550ioInterface.h"
#include "HTTPClient.h"

//EthernetInterface eth;
#if defined(TARGET_LPC1114)
SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
WIZ550ioInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
SPI spi(p11, p12, p13); // mosi, miso, sclk
WIZ550ioInterface eth(&spi, p14, p15); // spi, cs, reset

#endif

HTTPClient http;
char str[512];

int main() 
{
    int ret = eth.init(); //Use DHCP
    if (!ret)
    {
      printf("Initialized, MAC: %s\n", eth.getMACAddress());
    }
    else
    {
      printf("Error eth.init() - ret = %d\n", ret);
      return -1;
    }

    ret = eth.connect();
    if (!ret)
    {
      printf("Connected, IP: %s, MASK: %s, GW: %s\n",
        eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }
    else
    {
      printf("Error eth.connect() - ret = %d\n", ret);
      return -1;
    }
    
    
    //GET data
    printf("\nTrying to fetch page...\n");
    ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    
    printf("\n");
    ret = eth.disconnect();  
    if (!ret)
    {
      printf("Disconnected\n");
    }
    else
    {
      printf("Error eth.disconnect() - ret = %d\n", ret);
    }


    while(1) {
    }
}
