#include "mbed.h"
#include "GT20L16J1Y_font.h"

#define GT20L16J1Y_REMAP_ASCIIFONT  1
#define GT20L16J1Y_ENABLE_JISX0201  1

#if GT20L16J1Y_REMAP_ASCIIFONT
const uint16_t ascii_fontmap[] = {
0x0000, 0x015E, 0x0002, 0x007E, 0x0004, 0x0005, 0x0162, 0x0007, 
0x006E, 0x006F, 0x007D, 0x000B, 0x000C, 0x000D, 0x000E, 0x007F, 
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
0x0068, 0x0069, 0x006C, 0x006D, 0x001C, 0x001D, 0x001E, 0x015F, 
0x015D, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 
0x0128, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 
0x0130, 0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 
0x0138, 0x0139, 0x013A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 
0x0040, 0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147, 
0x0148, 0x0149, 0x014A, 0x014B, 0x014C, 0x014D, 0x014E, 0x014F, 
0x0150, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 
0x0158, 0x0159, 0x015A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 
};
#endif

#if GT20L16J1Y_ENABLE_JISX0201
const uint8_t jisx0201_fontmap[] = {
      0x0B, 0x1B, 0x1C, 0x0A, 0x50, 0x7E, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x13, 0x14, 0x15, 0x60, 
0x90, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 
0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 
0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0xFB, 0xFC, 
};

const uint8_t font_glyph_00A5[] = {
0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 
};
#endif

#if defined(TARGET_LPC1768)
GT20L16J1Y_FONT::GT20L16J1Y_FONT() : _spi(p11, p12, p13), _CS(p10) {
}
#endif

GT20L16J1Y_FONT::GT20L16J1Y_FONT(PinName mosi, PinName miso, PinName sclk, PinName cs) : _spi(mosi, miso, sclk, NC), _CS(cs)
{
    // Deselect the device
    _CS = 1;
    
    // Setup the spi for 8 bit data, high steady state clock
    _spi.format(8,3);
    _spi.frequency(10000000);
}   

int GT20L16J1Y_FONT::read_kuten(unsigned short code) {
    unsigned char MSB, LSB;
    uint32_t address;
    int ret;
    
    MSB = (code & 0xFF00) >> 8;
    LSB = code & 0x00FF;
    address = 0;
    
    if(     MSB >=  1 && MSB <= 15 && LSB >= 1 && LSB <= 94)
        address =( (MSB -  1) * 94 + (LSB - 1))*32;
    else if(MSB >= 16 && MSB <= 47 && LSB >= 1 && LSB <= 94)
        address =( (MSB - 16) * 94 + (LSB - 1))*32 + 0x0AA40L;
    else if(MSB >= 48 && MSB <= 84 && LSB >= 1 && LSB <= 94)
        address = ((MSB - 48) * 94 + (LSB - 1))*32 + 0x21CDFL;
    else if(MSB == 85 &&                LSB >= 1 && LSB <= 94)
        address = ((MSB - 85) * 94 + (LSB - 1))*32 + 0x3C4A0L;
    else if(MSB >= 88 && MSB <= 89 && LSB >= 1 && LSB <= 94)
        address = ((MSB - 88) * 94 + (LSB - 1))*32 + 0x3D060L;
    else if(MSB == 0 && LSB >= 0x20 && LSB <= 0x7F)
#if GT20L16J1Y_REMAP_ASCIIFONT
        address = ascii_fontmap[LSB - 0x20]*16 + 255968; // 0x3E7E0
#else
        address = (LSB - 0x20)*16 + 255968;
#endif
#if GT20L16J1Y_ENABLE_JISX0201
    else if(MSB == 0 && LSB == 0xA5) { // Font patch (0x00A5)
        memcpy(bitmap, font_glyph_00A5, 16);
        return 8;
    }
    else if(MSB == 0 && LSB >= 0xA1 && LSB <= 0xDF) // JIS X 0201
        address = jisx0201_fontmap[LSB - 0xA1]*16 + 257504; // 0x3EDE0
#endif
    
    // Deselect the device
    _CS = 1;
    
    //_spi.begin();
    _spi.write(0);  // Dummy (mbed: change SPI owner and SPI format.)
    
    // Select the device by seting chip select low
    _CS = 0;
    _spi.write(0x03);    // Read data byte
    _spi.write(address>>16 & 0xff);
    _spi.write(address>>8 & 0xff);
    _spi.write(address & 0xff);
    
#if GT20L16J1Y_ENABLE_JISX0201
    if(MSB == 0 && (LSB >= 0x20 && LSB <= 0x7F) || (LSB >= 0xA1 && LSB <= 0xDF)) {
#else
    if(MSB == 0 && LSB >= 0x20 && LSB <= 0x7F) {
#endif
        for(int i=0; i<16; i++)
        {
            bitmap[i] = _spi.write(0x00);
        }
        ret = 8;
    }
    else {
        for(int i=0; i<32; i++)
        {
            bitmap[i] = _spi.write(0x00);
        }
        ret = 16;
    }

    // Deselect the device
    _CS = 1;
    
    return ret;
}

int GT20L16J1Y_FONT::read(unsigned short code) {
    unsigned char c1, c2, MSB, LSB;
    uint32_t seq;
    uint16_t address;
    
    // SJIS to kuten code conversion
    c1 = (code>>8);
    c2 = (code & 0xFF);
    seq = (c1<=159 ? c1-129 : c1-193)*188 + (c2<=126 ? c2-64 : c2-65);
    MSB = seq / 94 + 1;
    LSB = seq % 94 + 1;
    
    address = ((MSB << 8) | LSB);
    return read_kuten(address);
}

void GT20L16J1Y_FONT::read_direct(unsigned long address) {
    // Deselect the device
    _CS = 1;
    
    //_spi.begin();
    _spi.write(0);  // Dummy (mbed: change SPI owner and SPI format.)
    
    // Select the device by seting chip select low
    _CS = 0;
    _spi.write(0x03);    // Read data byte
    _spi.write(address>>16 & 0xff);
    _spi.write(address>>8 & 0xff);
    _spi.write(address & 0xff);
    
    for(int i=0; i<32; i++)
    {
        bitmap[i] = _spi.write(0x00);
    }

    // Deselect the device
    _CS = 1;
}
