#include "mbed.h"
#include "iSDIO.h"
#include "HTTPClient.h"
#include "OAuth4Tw.h"

#if defined(TARGET_LPC11U24)
SD_iSDIO sd(p11, p12, p13, p14, "sd"); // MOSI, MISO, SCLK, SSEL
#elif defined(TARGET_LPC1114)
SD_iSDIO sd(p11, p12, p13, p14, "sd"); // MOSI, MISO, SCLK, SSEL
#elif defined(TARGET_LPC1549)
SD_iSDIO sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCLK, SSEL
#else
#error
#endif

Serial pc(USBTX, USBRX);

OAuth4Tw oa4t("XXXXXXXXXXXXXXXXXXXXXXXXX",                          // Consumer key
              "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", // Consumer secret
              "000000000-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", // Access token
              "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");     // Access token secret

//**************************************************
uint8_t buffer[512];
void printByte(uint8_t value)
{
    pc.printf("%x", value >> 4);
    pc.printf("%x", value & 0xF);
}
void printBytes(uint8_t* p, uint32_t len)
{
    for (int i = 0; i < len; ++i) {
        printByte(p[i]);
    }
}
void printIPAddress(uint8_t* p)
{
    pc.printf("%d", p[0]);
    pc.printf(".");
    pc.printf("%d", p[1]);
    pc.printf(".");
    pc.printf("%d", p[2]);
    pc.printf(".");
    pc.printf("%d", p[3]);
}
uint8_t iSDIO_status()
{
    pc.printf("\nRead iSDIO Status Register");
    // Read iSDIO Status Register (E7 1.10 2.2.2.1)
    memset(buffer, 0, 0x200);
    if (!sd.readExtMemory(1, 1, 0x400, 0x200, buffer)) {
        return false;
    }
#if 0
    for (int i = 0; i < 0x200; i++) {
        pc.printf("%2x ", buffer[i]);
        if ((i & 0xf) == 0xf) pc.printf("\n");
    }
#endif
    // Show values in the common status area.
    pc.printf("\n == iSDIO Status Registers == ");
    pc.printf("\n [0400h] Command Write Status: ");
    if (buffer[0x000] & 0x01) pc.printf("CWU ");
    if (buffer[0x000] & 0x02) pc.printf("CWA ");
    pc.printf("\n [0420h] iSDIO Status: ");
    if (buffer[0x020] & 0x01) pc.printf("CRU ");
    if (buffer[0x020] & 0x02) pc.printf("ESU ");
    if (buffer[0x020] & 0x04) pc.printf("MCU ");
    if (buffer[0x020] & 0x08) pc.printf("ASU ");
    pc.printf("\n [0422h] iSDIO Int Enable: ");
    if (buffer[0x022] & 0x01) pc.printf("CRU_ENA ");
    if (buffer[0x022] & 0x02) pc.printf("ESU_ENA ");
    if (buffer[0x022] & 0x04) pc.printf("MCU_ENA ");
    if (buffer[0x022] & 0x08) pc.printf("ASU_ENA ");
    pc.printf("\n [0424h] Error Status: ");
    if (buffer[0x024] & 0x01) pc.printf("CRE ");
    if (buffer[0x024] & 0x02) pc.printf("CWE ");
    if (buffer[0x024] & 0x04) pc.printf("RRE ");
    if (buffer[0x024] & 0x08) pc.printf("APE ");
    pc.printf("\n [0426h] Memory Status: ");
    if (buffer[0x026] & 0x01) pc.printf("MEX ");
    if (buffer[0x026] & 0x02) pc.printf("FAT ");
    for (int i = 0; i < 8; ++i) {
        uint8_t addr = 0x40 + i * 0x14;
        pc.printf("\n [04");
        printByte(addr);
        pc.printf("h] Command Response Status #");
        pc.printf("%d", i + 1);
        pc.printf(": ");
        if (buffer[addr] & 0x01) {
            pc.printf("id = ");
            pc.printf("%d", get_u16(buffer + addr + 2));
            pc.printf(", sequence id = ");
            pc.printf("%d", get_u32(buffer + addr + 4));
            pc.printf(", status = ");
            switch (buffer[addr + 8]) {
                case 0x00:
                    pc.printf("Initial");
                    break;
                case 0x01:
                    pc.printf("Command Processing");
                    break;
                case 0x02:
                    pc.printf("Command Rejected");
                    break;
                case 0x03:
                    pc.printf("Process Succeeded");
                    break;
                case 0x04:
                    pc.printf("Process Terminated");
                    break;
                default:
                    pc.printf("Process Failed ");
                    pc.printf("%h", buffer[addr + 8]);
                    break;
            }
        } else {
            pc.printf("Not registered");
        }
    }
    // Show values in the application status area.
    pc.printf("\n == Wireless LAN Status Registers ==");
    pc.printf("\n [0500h] DLNA Status: ");
    if (buffer[0x100] & 0x01) pc.printf("ULR ");
    if (buffer[0x100] & 0x02) pc.printf("DLU ");
    if (buffer[0x100] & 0x04) pc.printf("CBR ");
    if (buffer[0x100] & 0x08) pc.printf("CDR ");
    pc.printf("\n [0501h] P2P Status: ");
    if (buffer[0x101] & 0x01) pc.printf("ILU ");
    if (buffer[0x101] & 0x02) pc.printf("FLU ");
    pc.printf("\n [0502h] PTP Status: ");
    if (buffer[0x102] & 0x01) pc.printf("RPO ");
    if (buffer[0x102] & 0x02) pc.printf("RPD ");
    if (buffer[0x102] & 0x04) pc.printf("RPC ");
    if (buffer[0x102] & 0x08) pc.printf("CPI ");
    if (buffer[0x102] & 0x10) pc.printf("DPI ");
    if (buffer[0x102] & 0x20) pc.printf("CIL ");
    pc.printf("\n [0504h] Application: ");
    pc.printf((char *)buffer[0x104]);
    pc.printf("\n [0506h] WLAN: ");
    if ((buffer[0x106] & 0x01) == 0x00) pc.printf("No Scan, ");
    if ((buffer[0x106] & 0x01) == 0x01) pc.printf("Scanning, ");
    if ((buffer[0x106] & 0x06) == 0x00) pc.printf("No WPS, ");
    if ((buffer[0x106] & 0x06) == 0x02) pc.printf("WPS with PIN, ");
    if ((buffer[0x106] & 0x06) == 0x04) pc.printf("WPS with PBC, ");
    if ((buffer[0x106] & 0x08) == 0x00) pc.printf("Group Client, ");
    if ((buffer[0x106] & 0x08) == 0x08) pc.printf("Group Owner ");
    if ((buffer[0x106] & 0x10) == 0x00) pc.printf("STA, ");
    if ((buffer[0x106] & 0x10) == 0x10) pc.printf("AP, ");
    if ((buffer[0x106] & 0x60) == 0x00) pc.printf("Initial, ");
    if ((buffer[0x106] & 0x60) == 0x20) pc.printf("Infrastructure, ");
    if ((buffer[0x106] & 0x60) == 0x40) pc.printf("Wi-Fi Direct, ");
    if ((buffer[0x106] & 0x80) == 0x00) pc.printf("No Connection, ");
    if ((buffer[0x106] & 0x80) == 0x80) pc.printf("Connected, ");
    pc.printf("\n [0508h] SSID: ");
    for (int i = 0; i < 32 && buffer[0x108 + i] != 0; ++i) {
        pc.printf("%c", (char)buffer[0x108 + i]);
    }
    pc.printf("\n [0528h] Encryption Mode: ");
    switch (buffer[0x128]) {
        case 0 :
            pc.printf("Open System and no encryption");
            break;
        case 1 :
            pc.printf("Open System and WEP");
            break;
        case 2 :
            pc.printf("Shared Key and WEP");
            break;
        case 3 :
            pc.printf("WPA-PSK and TKIP");
            break;
        case 4 :
            pc.printf("WPA-PSK and AES");
            break;
        case 5 :
            pc.printf("WPA2-PSK and TKIP");
            break;
        case 6 :
            pc.printf("WPA2-PSK and AES");
            break;
        default:
            pc.printf("Unknown");
    }
    pc.printf("\n [0529h] Signal Strength: ");
    pc.printf("%d", buffer[0x129]);
    pc.printf("\n [052Ah] Channel: ");
    if (buffer[0x12A] == 0) pc.printf("No connection");
    else pc.printf("%d", buffer[0x12A]);
    pc.printf("\n [0530h] MAC Address: ");
    printBytes(buffer + 0x130, 6);
    pc.printf("\n [0540h] ID: ");
    for (int i = 0; i < 16 && buffer[0x140 + i] != 0; ++i) {
        pc.printf("%c", (char)buffer[0x140 + i]);
    }
    pc.printf("\n [0550h] IP Address: ");
    printIPAddress(buffer + 0x150);
    pc.printf("\n [0554h] Subnet Mask: ");
    printIPAddress(buffer + 0x154);
    pc.printf("\n [0558h] Default Gateway: ");
    printIPAddress(buffer + 0x158);
    pc.printf("\n [055Ch] Preferred DNS Server: ");
    printIPAddress(buffer + 0x15C);
    pc.printf("\n [0560h] Alternate DNS Server: ");
    printIPAddress(buffer + 0x160);
    pc.printf("\n [0564h] Proxy Server: ");
    if ((buffer[0x164] & 0x01) == 0x00) pc.printf("Disabled");
    if ((buffer[0x164] & 0x01) == 0x01) pc.printf("Enabled");
    pc.printf("\n [0570h] Date: ");
    pc.printf("%d", buffer[0x171] + 1980);
    pc.printf("-");
    pc.printf("%d", buffer[0x170] >> 4);
    pc.printf("-");
    pc.printf("%d", buffer[0x170] & 0xF);
    pc.printf("\n [0572h] Time: ");
    pc.printf("%d", buffer[0x173] >> 3);
    pc.printf(":");
    pc.printf("%d", buffer[0x172] << 3 | buffer[0x170] >> 3);
    pc.printf(":");
    pc.printf("%d", (buffer[0x172] & 0x1F) * 2);
    pc.printf("\n [0574h] HTTP Status: ");
    pc.printf("%d", buffer[0x174] & 0xEF);
    if ((buffer[0x174] & 0x80) == 0x00) pc.printf(" (No Processing)");
    if ((buffer[0x174] & 0x80) == 0x80) pc.printf(" (Processing)");
    pc.printf("\n [0575h] Power Save Management: ");
    if ((buffer[0x175] & 0x01) == 0x00) pc.printf("Power Save Mode Off");
    if ((buffer[0x175] & 0x01) == 0x01) pc.printf("Power Save Mode On");
    pc.printf("\n [0576h] File System Management: ");
    if ((buffer[0x176] & 0x01) == 0x00) pc.printf("FS Information may be modified");
    if ((buffer[0x176] & 0x01) == 0x01) pc.printf("FS Information shall not be modified");
    pc.printf("\n");

#if 0
    memset(buffer, 0, 0x200);
    if (!sd2->readExtMemory(1, 1, 0x600, 0x100, buffer)) {
        return false;
    }

    for (int i = 0; i < 0x100; i++) {
        pc.printf("%2x ", buffer[i]);
        if ((i & 0xf) == 0xf) pc.printf("\n");
    }
#endif

    return true;
}
//**************************************************

int main()
{
    pc.printf("start.\n");

    //Initialise card
    FILE *fp = fopen("/sd/mbed.txt", "w");
    fclose(fp);

    // WiFi Connection --------------------

    // Connection wait
    while(1) {
        memset(buffer, 0, 0x14);
        if (!sd.readExtMemory(1, 1, 0x506, 0x14, buffer)) {
            return -1;
        }
        uint8_t resp = get_u8(buffer);
        if ((resp & 0x80) != 0) {
            break;
        }
        pc.printf(".\n");
        wait_ms(1000);
    }

    // Dump status
    if (iSDIO_status() == false) {
        pc.printf("Failed to read status.\n");
        return -1;
    }

    // Abort command
    for (int i = 0; i < 8; ++i) {
        uint8_t addr = 0x40 + i * 0x14;
        if (buffer[addr] & 0x01) {
            int abortSequenceId = get_u32(buffer + addr + 4);
            int sequenceId = sd.getSequenceId();
            memset(buffer, 0, 512);
            uint8_t* p = buffer;
            p = put_command_header(p, 1, 0);
            p = put_command_info_header(p, 0x12, sequenceId, 2);
            p = put_u32_arg(p, abortSequenceId);
            put_command_header(buffer, 1, (p - buffer));
            if ( sd.writeExtDataPort(1, 1, 0x000, buffer) == false ) {
                return -1;
            }
            sd.waitResponse(sequenceId);
        }
    }
    for (int i = 0; i < 16; i++) {
        if (!sd.readExtDataPort(1, 1, 0x200, buffer)) {
            return -1;
        }
    }

    // Update time --------------------

    HTTPClient http;
    char str[512];

    pc.printf("Trying to update time...\n");
    int ret = http.get("http://ntp-a1.nict.go.jp/cgi-bin/jst", str, 128);
    if (ret) {
        pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        return -1;
    }

    pc.printf("Page fetched successfully - read %d characters\n", strlen(str));
    pc.printf("Result: %s\n", str);

    if (strncmp(str, "<HTML>", 6) != 0) {
        pc.printf("format error 1\n");
        return -1;
    }
    if (strncmp(&str[69], "</HTML>", 7) != 0) {
        pc.printf("format error 2\n");
        return -1;
    }

    str[56] = '\0';
    //pc.printf("%d\n", atol(&str[46]));
    set_time( atol(&str[46]) );

    time_t ctTime = time(NULL);
    pc.printf("Time is set to (UTC): %s\n", ctime(&ctTime));

    // Tweet --------------------

    std::string uri = "https://api.twitter.com/1.1/statuses/update.json";

    uri += "?status=";
    uri += OAuth4Tw::url_escape("Hello World!");
    uri += OAuth4Tw::url_escape(ctime(&ctTime));

    std::string postarg;
    std::string postres = oa4t.post(uri.c_str(), postarg);
    pc.printf("postres: %s\n", postres.c_str());

}
