//#define DEBUG

#include "mbed.h"

//DOGS102 Library
#include "DogLCD.h"
#include "Graphics.h"

#if defined(TARGET_LPC1768)
SPI spi(p11, NC, p13);
DogLCD dog(spi, p18, p20, p19); //  spi, cs, a0, reset
#elif defined(TARGET_LPC1114)
SPI spi(dp2, NC, dp6);
DogLCD dog(spi, dp9, dp11, dp10); //  spi, cs, a0, reset
#endif

Graphics g(&dog);

int main()
{
    dog.init();
    dog.clear_screen();
    
    int i;
    int px[5] = {5,10,20,30,60}, py[5] = {10,40,30,20,5}, cr[5] = {7,9,11,13,15};
    int ax[5] = {1,1,1,-1,-1}, ay[5] = {1,1,-1,-1,1};
    
#ifdef DEBUG
    Timer timer;
    timer.start();
    int frameno = 0;
    const int pollcount = 100;
#endif
    
    while(1)
    {
        // lock update
        dog.beginupdate();
        dog.clear_screen();
        
        g.line(0, 0, dog.width()-1, 0, 0xFFFFFF);
        g.line(dog.width()-1, 0, dog.width()-1, dog.height()-1, 0xFFFFFF);
        g.line(dog.width()-1, dog.height()-1, 0, dog.height()-1, 0xFFFFFF);
        g.line(0, dog.height()-1, 0, 0, 0xFFFFFF);
        
        for(i = 0; i < 5; i++)
        {
            g.circle(px[i]+cr[i], py[i]+cr[i], cr[i], 0xFFFFFF);
    
            px[i] += ax[i];
            py[i] += ay[i];
            
            if(px[i] <= 0 || px[i] >= dog.width() -cr[i]*2-1) ax[i] *= -1;
            if(py[i] <= 0 || py[i] >= dog.height()-cr[i]*2-1) ay[i] *= -1;
        }
        
        // unlock update (and draw framebuffer)
        dog.endupdate();
        
#ifdef DEBUG
        if ( ++frameno == pollcount )
        {
            // output fps to serial
            int end = timer.read_ms();
            float fps = pollcount*1000.0/end;
            printf("%d frames, %d ms, FPS: %f\n", pollcount, end, fps);
            frameno = 0;
            timer.reset();
        }
#endif
        
        wait_ms(40);
    }
}
