#ifndef MBED_TIEFIGHTER_H
#define MBED_TIEFIGHTER_H



int tie_fighter_vertices[48][3] = {
    // Left wing - v0
    {0, 0, 17},
    {10, -15, 15},
    {-10, -15, 15},
    {-15, 0, 15},
    {-10, 15, 15},
    {-10, 15, 15},
    {10, 15, 15},
    {15, 0, 15},

    // Left inner wing connector - v8
    {0, 0, 17},
    {4, -4, 15},
    {-4, -4, 15},
    {-4, 0, 15},
    {-4, 4, 15},
    {-4, 4, 15},
    {4, 4, 15},
    {4, 0, 15},
    
    // Right wing - v16
    {0, 0, -17},
    {10, -15, -15},
    {-10, -15, -15},
    {-15, 0, -15},
    {-10, 15, -15},
    {-10, 15, -15},
    {10, 15, -15},
    {15, 0, -15},
    
    // Right inner wing connector - v24
    {0, 0, -17},
    {4, -4, -15},
    {-4, -4, -15},
    {-4, 0, -15},
    {-4, 4, -15},
    {-4, 4, -15},
    {4, 4, -15},
    {4, 0, -15},
    
    // Body - v32
    {8, 8, -8},
    {-8, 8, -8},
    {8, 8, 8},
    {-8, 8, 8},
    
    {8, -8, -8},
    {-8, -8, -8},
    {8, -8, 8},
    {-8, -8, 8},

    // Left wing <-> body connection
    {-2, -2, 15},
    {-2, -2, 8},
    {2, 2, 15},
    {2, 2, 8},
    
    // Right wing <-> body connection
    {-2, -2, -15},
    {-2, -2, -8},
    {2, 2, -15},
    {2, 2, -8},
};

#define TIE_FIGHTER_NUM_FACES 32
int tie_fighter_faces[TIE_FIGHTER_NUM_FACES][3] = {
    // Left wing
    {0, 1, 2},
    {0, 2, 3},
    {0, 3, 4},
    {0, 4, 5},
    {0, 5, 6},
    {0, 6, 7},
    {0, 7, 1},

    // Left inner wing connector
/*    {8, 9, 10},
    {8, 10, 11},
    {8, 11, 12},
    {8, 12, 13},
    {8, 13, 14},
    {8, 14, 15},
    {8, 15, 9}, */
    
    // Right wing
    {16, 17, 18},
    {16, 18, 19},
    {16, 19, 20},
    {16, 20, 21},
    {16, 21, 22},
    {16, 22, 23},
    {16, 23, 17},
    
    // Right inner wing connector
/*    {24, 25, 26},
    {24, 26, 27},
    {24, 27, 28},
    {24, 28, 29},
    {24, 29, 30},
    {24, 30, 31},
    {24, 31, 25},   */
    
    // Body
    {32, 33, 33}, // Hack to just draw some straight lines so the body doesn't look too cluttered with triangles
    {33, 35, 35},
    {35, 34, 34},
    {32, 34, 34},
    
    {36, 37, 37},
    {37, 39, 39},
    {39, 38, 38},
    {36, 38, 38},
    
    {36, 32, 32},
    {37, 33, 33},
    {39, 35, 35},
    {38, 34, 34},
    
    // Left wing <-> body connection
    {40, 41, 41},
    {42, 43, 43},

    // Right wing <-> body connection
    {44, 45, 45},
    {46, 47, 47},    
};

#endif
