#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "OAuth4Tw.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
EthernetInterface eth;
NTPClient ntp;

OAuth4Tw oa4t("XXXXXXXXXXXXXXXXXXXXXXXXX",                          // Consumer key
              "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", // Consumer secret
              "000000000-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", // Access token
              "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");     // Access token secret

#if defined(TARGET_LPC1768)
#define RESPONSE_BUFFER_SIZE 512
#elif defined(TARGET_K64F) || defined(TARGET_LPC4088)
#define RESPONSE_BUFFER_SIZE 4096
#else
#error not tested platform.
#endif

char response_buffer[RESPONSE_BUFFER_SIZE];
HTTPText response(response_buffer, sizeof(response_buffer));

// prototype
void updateTime();
void example_tweet1();
void example_tweet2();
void example_tweet3();
void example_getUserData();

int main()
{
    pc.baud(115200);

    eth.init(); //Use DHCP
    printf("Initialized, MAC: %s\n", eth.getMACAddress());

    int ret;
    while ((ret = eth.connect()) != 0) {
        printf("Error eth.connect() - ret = %d\n", ret);
    }

    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

    // requires accurate time, for OAuth Authorization.
    updateTime();

    while (1) {

        example_tweet1();
        //example_tweet2();
        //example_tweet3();

        example_getUserData();

        // Wait 60 seconds for next time.
        for (int t=0; t<60; t++) {
            myled = 1;
            wait(0.2);
            myled = 0;
            wait(0.8);
        }

        printf("\n");
    }
}


void updateTime()
{
    printf("Trying to update time...\n");

    time_t ctTime;
    NTPResult result;

    while (1) {
        result = ntp.setTime("pool.ntp.org");
        //result = ntp.setTime("pool.ntp.org", NTP_DEFAULT_PORT, 2000);

        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC): %s\n", ctime(&ctTime));
            break;
        }

        switch (result) {
            case NTP_CONN:      ///<Connection error
                printf("Connection error\n");
                break;
            case NTP_TIMEOUT:   ///<Connection timeout
                printf("Connection timeout\n");
                break;
            case NTP_PRTCL:     ///<Protocol error
                printf("Protocol error\n");
                break;
            case NTP_DNS:       ///<Could not resolve name
                printf("Could not resolve name\n");
                break;
            default:
                printf("Error result=%d\n", result);
                break;
        }

        wait(5);
    }
}


void example_tweet1()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json"
                       "?status=Hello World! - %s";
    char url2[128];

    time_t ctTime;
    time(&ctTime);

    snprintf(url2, sizeof(url2), url, ctime(&ctTime));

    HTTPResult result = oa4t.post(url2, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_tweet2()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json";

    std::vector<std::string> post;
    post.reserve(1);

    char status[128];

    time_t ctTime;
    time(&ctTime);

    snprintf(status, sizeof(status), "status=Hello World! - %s", ctime(&ctTime));
    post.push_back(status);

    HTTPResult result = oa4t.post(url, &post, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_tweet3()
{
    const char url[] = "https://api.twitter.com/1.1/statuses/update.json";

    std::vector<std::string> post;
    post.reserve(3);

    struct tm tmptr;
    char tmstr[34];
    char status[128];
    char location_lat[24];
    char location_long[24];

    time_t ctTime;
    time(&ctTime);
    ctTime += 9 * 60 * 60;  // Timezone: JST(+9h)
    localtime_r(&ctTime, &tmptr);

    // Tweets in Japanese
    strftime(tmstr, sizeof(tmstr), "%Y年%m月%d日 %H時%M分%S秒", &tmptr);
    snprintf(status, sizeof(status), "status=ハロー・ワールド！ - %s", tmstr);
    post.push_back(status);

    // Option: add Location information
    snprintf(location_lat, sizeof(location_lat), "lat=%f", 35.359577);
    snprintf(location_long, sizeof(location_long), "long=%f", 138.731414);
    post.push_back(location_lat);
    post.push_back(location_long);

    HTTPResult result = oa4t.post(url, &post, &response);

    if (result == HTTP_OK) {
        printf("POST success.\n%s\n", response_buffer);
    } else {
        printf("POST error. (result = %d)\n", result);
    }
}

void example_getUserData()
{
    const char url[] = "https://api.twitter.com/1.1/users/show.json"
                       "?screen_name=twitter";

    HTTPResult result = oa4t.get(url, &response);

    if (result == HTTP_OK) {
        printf("GET success.\n%s\n", response_buffer);
    } else {
        printf("GET error. (result = %d)\n", result);
    }
}
