#if 0
/* mouse_demo.cpp */
#include "mbed.h"
#include <btstack/run_loop.h>
#include <btstack/hci_cmds.h>
#include "hci.h"
#include "l2cap.h"
#include "debug.h"
#include "bd_addr.h"  // class bd_addr
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3);

#define INQUIRY_INTERVAL 15

bd_addr addr;

static void hid_process_packet(uint8_t* report, int size)
{
    if (report[0] == 0xa1 && report[1] == 0x02) {
        led1 = report[2] & 0x01; // left
        led2 = report[2] & 0x02; // right
        led3 = report[2] & 0x04; // center
    }
    hexdump(report, size);
}

static void l2cap_packet_handler(uint8_t packet_type, uint16_t channel, uint8_t *packet, uint16_t size){
    
    if (packet_type == HCI_EVENT_PACKET && packet[0] == L2CAP_EVENT_CHANNEL_OPENED){
        if (packet[2]) {
            log_info("Connection failed\n");
            return;
        }
        log_info("Connected\n");
    }
    if (packet_type == L2CAP_DATA_PACKET){
        // handle input
        log_info("HID report, size %u\n", size);
        hid_process_packet(packet, size);
    }
}

static void packet_handler(void * connection, uint8_t packet_type, uint16_t channel, uint8_t *packet, uint16_t size){
    if (packet_type == HCI_EVENT_PACKET) {
        switch (packet[0]) {
            case BTSTACK_EVENT_STATE:
                // bt stack activated, get started - set local name
                if (packet[2] == HCI_STATE_WORKING) {
                    hci_send_cmd(&hci_write_authentication_enable, 1);
                }
                break;
                    
            case HCI_EVENT_INQUIRY_RESULT:
                // ignore none mouses
                if ((packet[12] & 0x80) != 0x80 || packet[13] != 0x25) break;
                addr.data(&packet[3]);
                log_info("Mouse addr: %s\n", addr.to_str());
                hci_send_cmd(&hci_inquiry_cancel);
                break;
                    
            case HCI_EVENT_INQUIRY_COMPLETE:
                log_info("No mouse found :(\n");
                break;
                
            case HCI_EVENT_LINK_KEY_REQUEST:
                // deny link key request
                hci_send_cmd(&hci_link_key_request_negative_reply, addr.data());
                break;
                    
            case HCI_EVENT_PIN_CODE_REQUEST:
                // inform about pin code request
                log_info("Enter 0000\n");
                hci_send_cmd(&hci_pin_code_request_reply, addr.data(), 4, "0000");
                break;
                    
            case HCI_EVENT_COMMAND_COMPLETE:
                if (COMMAND_COMPLETE_EVENT(packet, hci_write_authentication_enable)){
                    log_info("Inquiry\n");
                    hci_send_cmd(&hci_inquiry, HCI_INQUIRY_LAP, INQUIRY_INTERVAL, 0);
                }
                if (COMMAND_COMPLETE_EVENT(packet, hci_inquiry_cancel) ) {
                    // inq successfully cancelled
                    log_info("Connecting\n");
                    l2cap_create_channel_internal(NULL, l2cap_packet_handler, addr.data(), PSM_HID_INTERRUPT, 150);
                }
                break;
        }
    }
}

int main(void){
    pc.baud(921600);
    log_info("%s\n", __FILE__);

    // init LEDs
    led1 = led2 = led3 = 1;
    
    // GET STARTED
    run_loop_init(RUN_LOOP_EMBEDDED);

    // init HCI
    hci_transport_t* transport = hci_transport_usb_instance();
    remote_device_db_t* remote_db = (remote_device_db_t *)&remote_device_db_memory;
    hci_init(transport, NULL, NULL, remote_db);

    // init L2CAP
    l2cap_init();
    l2cap_register_packet_handler(packet_handler);

    // turn on!, send RESET command
    hci_power_control(HCI_POWER_ON);
            
    // go!
    run_loop_execute();    
    
    return 0;
}
#endif