#include "mbed.h"
#include "picture.h"
#include "AkiSpiLcd.h"

/*
1 MOSI     D11
2 MISO     D12
3 SCLK     D13
4 CS(1)    D2  (AkiSpi LCD)
5 CS(2)    D3  (23K256 SRAM)
  EXTCOMIN D4
  DISP     D5  (Low = Off Display)
*/

#ifdef TARGET_KL46Z
AkiSpiLcd lcd(D11, D12, D13, D2, D3);
#endif

extern const uint8_t picture[];

int main()
{
    const int randline[240] = {
        0xBE, 0xAE, 0x64, 0xD4, 0xB8, 0xA9, 0xD5, 0xC5, 0x0D, 0x41, 0x44, 0xD2, 0xD7, 0x15, 0x62, 0x65, 
        0xBB, 0xC6, 0x29, 0x14, 0x66, 0x51, 0xBC, 0xDE, 0x7B, 0xE5, 0xEF, 0xC0, 0x68, 0x2E, 0x91, 0xA0, 
        0x96, 0x71, 0x8B, 0x8A, 0x9D, 0x5D, 0xDF, 0x48, 0x56, 0x04, 0x49, 0x60, 0xA5, 0xEA, 0x7F, 0xD8, 
        0x22, 0xD3, 0x33, 0xC2, 0xB3, 0xCA, 0x28, 0x1C, 0x30, 0x89, 0x2B, 0x34, 0x95, 0x83, 0x11, 0xA3, 
        0x78, 0x80, 0x2C, 0xA7, 0xC7, 0x57, 0x55, 0x5F, 0x97, 0x00, 0x1A, 0x70, 0x7E, 0x73, 0xED, 0x52, 
        0xA6, 0x6C, 0xA4, 0xAA, 0xD6, 0x81, 0x24, 0x74, 0x21, 0xB0, 0x5E, 0x0C, 0x46, 0x87, 0x63, 0xD9, 
        0xE1, 0xA8, 0xBF, 0xB7, 0x8F, 0x0A, 0x1D, 0x40, 0xDD, 0x4D, 0x58, 0x86, 0xEC, 0xE0, 0x1F, 0x13, 
        0x53, 0x9E, 0xC3, 0xE9, 0xCB, 0x20, 0xCD, 0x17, 0x50, 0xA1, 0x5C, 0xAB, 0x25, 0xEE, 0x47, 0x3F, 
        0x35, 0xC9, 0x9B, 0x3E, 0xC4, 0x3D, 0x3C, 0xCC, 0x8D, 0x4E, 0xBD, 0x4F, 0xBA, 0x01, 0x59, 0x6B, 
        0x32, 0x61, 0x26, 0x98, 0x10, 0x75, 0xAF, 0x2A, 0x03, 0x38, 0x88, 0x7D, 0x5B, 0x85, 0x6A, 0xDC, 
        0x05, 0x84, 0x9A, 0x43, 0xA2, 0x6F, 0xB1, 0x5A, 0xAD, 0xEB, 0x6E, 0x3B, 0x02, 0xB2, 0xE4, 0xE2, 
        0x69, 0xDB, 0xC1, 0x12, 0x42, 0x27, 0x2F, 0x31, 0x90, 0xAC, 0xB9, 0x2D, 0x09, 0x16, 0xE7, 0x8E, 
        0xB6, 0x77, 0xB4, 0x67, 0x4B, 0x9C, 0x3A, 0x82, 0x4C, 0x08, 0xDA, 0x23, 0xB5, 0xC8, 0x7A, 0x39, 
        0xE8, 0x45, 0xE6, 0x36, 0x92, 0xD1, 0xCE, 0x93, 0x0E, 0x4A, 0x76, 0x7C, 0x79, 0xD0, 0x1E, 0xE3, 
        0x1B, 0x37, 0x0F, 0x6D, 0x07, 0xCF, 0x94, 0x72, 0x54, 0x99, 0x06, 0x19, 0x0B, 0x18, 0x9F, 0x8C, 
    };

    wait_ms(1);

    while(1) {
        lcd.cls();

        wait_ms(100);

        //lcd.directUpdateSingle(10,(uint8_t*)(picture+2000));
        //lcd.directUpdateMulti(100,(240-100),(uint8_t*)(picture));

        for(int i=0; i<240; i++) {
            int l = randline[i];
            lcd.directUpdateMulti(l,1,(uint8_t*)(picture+50*l));
            wait_ms(5);
        }

        wait(3);

        for(int i=0; i<240; i++) {
            lcd.directUpdateMulti(i,(240-i),(uint8_t*)(picture));
            lcd.directUpdateMulti(0,(i),(uint8_t*)(picture+50*(240-i)));
        }

        lcd.directUpdateMulti(0,(240),(uint8_t*)(picture));
        
        wait(5);
    }
}
