 

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MFS.h"


// DURATION: Zeit in ms nach der weitergezählt wird
// DIGIT_AN: Zeit nach der das Digit weitergeschaltet wird (Multiplexing)
// verändern Sie die Vorgaben-> "DIGIT_AN 100" und "DURATION 200"
#define DIGIT_AN                                                         2
#define DURATION                                                         10
int f=1;
void init (void){
    RCC->APB1ENR |=0b10000;
    TIM6->PSC=31999;
    TIM6->ARR=10;
    TIM6->CNT=0;
    TIM6->SR=0;
    TIM6->CR1=1;
    }


MFS display;
char seg7[10]={0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F};  // Bitmuster für Ziffer 0 bis 9
int digitAnzeige[4]={0x1000,0x2000,0x4000,0x8000}; // vier 7-Segmentanzeigen von Digit0 bis Digit3

int digitPos = 0;   // Welches der 4 Digits ist ausgewählt
int einer = 0;      // Zahl die auf der Einerstelle ausgegeben wird
int zehner = 0;     // Zahl die auf der Einerstelle ausgegeben wird
int hunderter = 0;
int tausender = 0;
int setzeEiner = digitAnzeige[digitPos] + seg7[einer];      // Initialisierung Anzeige digit0 mit Zahl 0
int setzeZehner = digitAnzeige[digitPos+1] + seg7[zehner];  // Initialisierung Anzeige digit1 mit Zahl 0
int setzeHunderter = digitAnzeige[digitPos+2]+seg7[hunderter];
int setzeTausender= digitAnzeige[digitPos+3]+seg7[tausender];
// Funktion zur Anzeige der Einer- /Zehnerstelle für DIGIT_AN
void displayAusgabe(void) {
  display=setzeEiner;
  HAL_Delay(DIGIT_AN);
  display=setzeZehner;
  HAL_Delay(DIGIT_AN);
  display=setzeHunderter;
  HAL_Delay(DIGIT_AN);
  display=setzeTausender;  
  HAL_Delay(DIGIT_AN); 
  }

int main()
{
init();    
// Berechne Anzahl an Schleifendurchgängen für DURATION
int count = DURATION / (4*DIGIT_AN);
 
 while (true) {
     
  for (int i=0; i<= count; i++) {        // Warteschleife bevor weitergezählt wird
     displayAusgabe();
     printf("Variable f: %d \n",f);
     }
     
    einer++;
    f++;                            // zähle eins hoch
    if (einer > 9) {                // Wert größer als 9? Dann beginne "einer" von 0
        einer=0;
        zehner++;               // erhöhe Zehner
            if (zehner > 9) {
            zehner =0;
            hunderter++;
         }
         if (hunderter>9){
             hunderter=0;
             tausender++;
             }
             if(tausender>9){
                 tausender=0;
                 }
             
        }
    setzeEiner = digitAnzeige[digitPos] + seg7[einer];
    setzeZehner = digitAnzeige[digitPos+1] + seg7[zehner];
    setzeHunderter = digitAnzeige[digitPos+2]+seg7[hunderter];
    setzeTausender = digitAnzeige[digitPos+3]+seg7[tausender];

 }
}  
  

