#include "mbed.h"
#include "platform/mbed_thread.h"
 
using namespace std::chrono;
 
InterruptIn    user_button(USER_BUTTON);
DigitalOut     led(LED1);
 
bool           executeMainTask = false;
Timer          user_button_timer, loop_timer;
int            Ts_ms = 50;
 
void           button_fall();
void           button_rise();

//Peripherie
AnalogIn    analog_in_A0(PA_0);         //FS Futter Behälter Ultraschall
AnalogIn    analog_in_A1(PA_1);         //FS Wasser Behälter Ultraschall
AnalogIn    analog_in_A2(PA_4);         //FS Futter Napf Waage
AnalogIn    analog_in_A3(PB_0);         //FS Wasser Napf Wasserstand
//AnalogOut   analog_out_PA_4(PA_4);      //Futterausgabe DC-Motor
//AnalogOut   analog_out_PA_5(PA_5);      //Wasserausgabe Ventil
//DigitalOut  Low_Level_PA_6(PA_6);       //Warn-LED Füllstand

float       Food_US = 0.0f;
float       Water_US = 0.0f;
float       Food_Bowl = 0.0f;
float       Water_Bowl = 0.0f;
int         counter = 0;

int main()
{
    user_button.fall(&button_fall);
    user_button.rise(&button_rise);
    loop_timer.start();
 
    while (true) {
 
        loop_timer.reset();
 
        /* ------------- start hacking ------------- -------------*/
 
        if(executeMainTask) {
            //Futterlager
            Food_US = analog_in_A0.read();
            //Wasserlager
            Water_US = analog_in_A1.read();
            //Futternapf
            Food_Bowl = analog_in_A2.read();
            //Wassernapf
            Water_Bowl = analog_in_A3.read();
            
            //Ausgabe
            switch(counter) {
                case 1:
                    printf("Futterlager:    %d\r\n", (static_cast<int>(Food_US*100)));
                    break;
                case 2:
                    printf("Wasserlager:    %d\r\n", (static_cast<int>(Water_US*100)));
                    break;
                case 3:
                    printf("Futterpegel:    %d\r\n", (static_cast<int>(Food_Bowl*100)));
                    break;
                case 4:
                    printf("Wasserpegel:    %d\r\n\n\n", (static_cast<int>(Water_Bowl*100)));
                    break;
                case 20:
                    counter = 0;
                    break;
                default:
                    break;
            }
            counter++;
            
        /* ------------- stop hacking ------------- -------------*/
            led = !led;
        } else {
            led = 0;
        }
        
        int T_loop_ms = duration_cast<milliseconds>(loop_timer.elapsed_time()).count();
        int dT_loop_ms = Ts_ms - T_loop_ms;
        thread_sleep_for(dT_loop_ms);
    }
}
 
void button_fall()
{
    user_button_timer.reset();
    user_button_timer.start();
}
 
void button_rise()
{
    int t_button = duration_cast<milliseconds>(user_button_timer.elapsed_time()).count();
    user_button_timer.stop();
    if(t_button > 200) executeMainTask = !executeMainTask;
}