/*
    Projekt Fütterungsstation
    Name:   main.cpp
    Datum:  26.04.21
    Autor:  Joel Balsiger, Simon Künzli
*/

//Include von Files
#include "mbed.h"
#include "platform/mbed_thread.h"
#include <ttmathbig.h>

//Vorlage Zeit & Buttons
using namespace std::chrono;
 
InterruptIn    user_button(USER_BUTTON);
DigitalOut     led(LED1);

bool           executeMainTask = false;
Timer          user_button_timer, loop_timer;
int            Ts_ms = 50;

void           button_fall();
void           button_rise();

//Peripherie
AnalogIn    analog_in_PA_0(PA_0);       //FS Futter Behälter Ultraschall
AnalogIn    analog_in_PA_1(PA_1);       //FS Wasser Behälter Ultraschall
AnalogIn    analog_in_PA_2(PA_2);       //FS Futter Napf Waage
AnalogIn    analog_in_PA_3(PA_3);       //FS Wasser Napf Wasserstand
AnalogOut   analog_out_PA_4(PA_4);      //Futterausgabe DC-Motor
AnalogOut   analog_out_PA_5(PA_5);      //Wasserausgabe Ventil
DigitalOut  Low_Level_PA_6(PA_6);       //Warn-LED Füllstand

//Funktionen
int Food_Bowl_Check();                  //Futterstand auslesen

void Give_Out_Food(int max_Food);       //Futter ausgeben bis Limit erreicht

int Water_Bowl_Check();                 //Wasserstand auslesen

void Give_Out_Water(int max_Water);     //Wasser ausgeben bis Limit erreicht

int Get_FS_Food();                      //Füllstand Futtrbehälter auslesen

int Get_FS_Water();                     //Füllstand Futtrbehälter auslesen

//Main Programm
int main()
{
    //Vorlage Zeit & Buttons
    user_button.fall(&button_fall);
    user_button.rise(&button_rise);
    loop_timer.start();
    
    //Initialisierung
    int FoodOut = 0, WaterOut = 0;
    int Refill_Pressed = 1;             //Taste für Nachfüllen
    int max_Food = 80;                  //Limit in % Futtermenge
    int max_Water = 80;                 //Limit in % Wassermenge
    int FS_Food, FS_Water;              //Füllstand Behälter in %
    int Warning_Low_Level = 0;          //Warnung tiefer Füllstand
    double Time_Counter = 0;            //Anzahl x * 50ms
    double Time_Interval = 8;           //Futterauffüllung nach x Stunden
    
    //Endlosschlaufe
    while(1)
    {
        loop_timer.reset();
        
        //Start
        //Telegram Internetansteuerung
        
        //Tastenabfrage
        //Check Taster
        if(Refill_Pressed == 0) {
            FoodOut = 1;
            WaterOut = 1;
        }
        
        //Futterausgabe
        if(FoodOut == 1){
            Give_Out_Food(max_Food);
            FoodOut = 0;
        }
        
        //Wasserausgabe
        if(WaterOut == 1){
            Give_Out_Water(max_Water);
            WaterOut = 0;
        }
        
        //Füllstand aktualisieren
        FS_Food = Get_FS_Food();
        FS_Water = Get_FS_Water();
        
        //Füllstand Warnung
        if(FS_Food <= 10 || FS_Water <= 10){
            Low_Level_PA_6.write(1);     //Warn-LED ein
            Warning_Low_Level = 1;
        } else{
            Low_Level_PA_6.write(0);     //Warn-LED aus
            Warning_Low_Level = 0;
        }
        //Zeitinterval Futterauffüllung
        if(Time_Counter >= Time_Interval *60 *60 *20){
            FoodOut = 1;
            WaterOut = 1;
            Time_Counter = 0;
        }
        Time_Counter++;
        
        //Stop
        int T_loop_ms = duration_cast<milliseconds>(loop_timer.elapsed_time()).count();
        int dT_loop_ms = Ts_ms - T_loop_ms;
        thread_sleep_for(dT_loop_ms);
    }
}

//Funktionen
int Food_Bowl_Check(){                  //Futterstand auslesen
    int Bowl_Level = 30, V_In, R_FSR, R = 100000, V_plus = 5;
    //Bowl_Level = Drucksensor Ausgabe
    //V_In = analog_in_PA_2.read() * 5;       //0-1
    //R_FSR = (V_plus / V_In) * R - R     //0-R
    Bowl_Level = round(analog_in_PA_2.read() * 100);   //0-100
    return Bowl_Level;
}

void Give_Out_Food(int max_Food){       //Futter ausgeben bis Limit erreicht
    while (Food_Bowl_Check() <= max_Food){
        //DC Motor drehen
        analog_out_PA_4.write(1);       //0-1 -> 0-5V
    }
    //DC Motor stoppen
    analog_out_PA_4.write(0);
}

    int Water_Bowl_Check(){             //Wasserstand auslesen
    int Bowl_Level = 100;
    //Bowl_Level = Füllstand Ausgabe
    Bowl_Level = round(analog_in_PA_3.read() * 100);    //0-1 * 100
    return Bowl_Level;
}

void Give_Out_Water(int max_Water){     //Wasser ausgeben bis Limit erreicht
    while (Water_Bowl_Check() <= max_Water){
        //Ventil Öffnen
        analog_out_PA_5.write(1);       //0-1 -> 0-5V
    }
    //Ventil Schliessen
    analog_out_PA_5.write(0);
}

int Get_FS_Food(){                      //Füllstand Futtrbehälter auslesen
    int Level, max_distance = 120;                                          //distance in mm
    //Level = 100% - Ultraschallsensor in %
    Level = 100 - round(analog_in_PA_0.read() *3.3f / max_distance * 100);  //100% -(x * 3.3 / max * 100)
    return Level;
}

int Get_FS_Water(){                     //Füllstand Wasserbehälter auslesen
    int Level, max_distance = 120;                                          //distance in mm
    //Level = 100% - Ultraschallsensor in %
    Level = 100 - round(analog_in_PA_1.read() *3.3f / max_distance * 100);  //100% -(x * 3.3 / max * 100)
    return Level;
}

void button_fall()
{
    user_button_timer.reset();
    user_button_timer.start();
}

void button_rise()
{
    int t_button = duration_cast<milliseconds>(user_button_timer.elapsed_time()).count();
    user_button_timer.stop();
    if(t_button > 200) executeMainTask = !executeMainTask;
}