#ifndef TUIASI_PIXY_H
#define TUIASI_PIXY_H

#include "mbed.h"
#include "PixyLinkSPI.h"
#include "PixyLinkI2C.h"
#include "PixyLinkUART.h"

struct Block {
    void print(Serial &pc) {
        pc.printf("sig: %d x: %d y: %d width: %d height: %d angle: %d \n\r", signature, x, y, width, height, angle);
    };
    uint16_t type;
    uint16_t signature;
    uint16_t x;
    uint16_t y;
    uint16_t width;
    uint16_t height;
    int16_t angle;
};

class Pixy
{
public:
    enum LinkType {SPI, I2C, UART};
    Pixy(LinkType linkType, PinName mosi_sda_tx, PinName miso_scl_rx, PinName sclk = NC);
    ~Pixy();
    uint16_t getBlocks(uint16_t maxBlocks=1000);
    int8_t setServos(uint16_t s0, uint16_t s1);
    void setAddress(uint8_t addr);
    void setSerialOutput(Serial *pc);

    Block *blocks;

private:
    static const uint8_t PIXY_INITIAL_ARRAYSIZE = 30;
    static const uint8_t PIXY_MAXIMUM_ARRAYSIZE = 130;
    static const uint16_t PIXY_START_WORD = 0xaa55;
    static const uint16_t PIXY_START_WORD_CC = 0xaa56;
    static const uint16_t PIXY_START_WORDX = 0x55aa;
    static const uint8_t PIXY_DEFAULT_ADDR = 0x54;  // I2C

    bool getStart(uint16_t *type);
    void resize();

    bool skipStart;
    uint16_t blockCount;
    uint16_t blockArraySize;

    PixyLink *m_link;
    Serial *pc;
};
#endif //TUIASI_PIXY_H