/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef RPCFUNCTION_RPC
#define RPCFUNCTION_RPC

#include "rpc.h"
#define STR_LEN 64

namespace mbed {

/**
 *
 *Class to call custom functions over RPC
 *
 */
class RPCFunction: public RPC {
public:
    /**
     * Constructor
     * 
     *@param f Pointer to the function to call. the function must be of the form void foo(char * input, char * output)
     *@param name The name of this object
     */
    RPCFunction(void (*f)(Arguments*, Reply*), const char* = NULL);

    /** 
     *run 
     *
     *Calls the attached function passing the string in but doesn't return the result.
     *@param str The string to be passed into the attached function. This string can consist of any ASCII characters apart from escape codes. The usual limtations on argument content for RPC strings has been removed
     *@return A string output from the function
     */
    void run(Arguments* args, Reply* r);

    virtual const struct rpc_method *get_rpc_methods();

private:
    void (*_ftr)(Arguments*, Reply*);

    char _input[STR_LEN];
    char _output[STR_LEN];
};

}

#endif
